<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

use FiloBlu\OrderFlowRectifier\Api\RectifierInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\App\State;

class StateFixForCanceledOrders implements RectifierInterface
{
    protected $connection;

    /**
     * @var State
     */
    protected $state;

    public function __construct(
        ResourceConnection $connection,
        State $state
    )
    {
        $this->connection = $connection->getConnection();
        $this->state = $state;
    }

    public function getInfo()
    {
        return 'Fix state from new to canceled for canceled orders';
    }

    public function getTitle()
    {
        return 'Rectifier to fix state for canceled orders';
    }

    public function executeSingle($order)
    {
        try {
            $this->state->getAreaCode();
        } catch (\Exception $e) {
            $this->state->setAreaCode('crontab');
        }

        $orderTable = $this->connection->getTableName('sales_order');
        $affectedRows = $this->connection->update(
            $orderTable,
            ['state' => 'canceled'],
            ['entity_id = ?' => $order->entity_id]
        );
        return $affectedRows > 0;
    }

    public function loadOrders()
    {
        $orderTable = $this->connection->getTableName('sales_order');

        $query = "SELECT increment_id, entity_id
        FROM {$orderTable}
        WHERE
            status = 'canceled' AND
            state = 'new'
        LIMIT 20";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);

        return $ordersToBeRectified;
    }
}
