<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

class ShippedRectifier implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{

    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource)
    {
        $this->connection = $resource->getConnection();
    }

    public function getInfo() {
        return "Fix orders that should be complete, but they are still shipped.";
    }

    public function getTitle() {
        return "Orders stuck in shipped status";
    }

    /**
     * Fix order by changing state and status to "complete"
     * @param $order
     * @return bool
     * @throws \Exception
     */
    public function executeSingle($order) {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderGridTable = $this->connection->getTableName('sales_order_grid');
        $this->connection->beginTransaction();
        try {
            $affectedRows = $this->connection->update(
                $orderTable,
                [
                    'state' => 'complete',
                    'status' => 'complete',
                ],
                ['entity_id = ?' => $order->entity_id]
            );
            $affectedRows += $this->connection->update(
                $orderGridTable,
                [
                    'status' => 'complete',
                ],
                ['increment_id = ?' => $order->increment_id, 'store_id = ?' => $order->store_id]
            );
            $this->connection->commit();
        } catch (\Exception $e) {
            $this->connection->rollBack();
            throw $e;
        }
        return $affectedRows == 2;
    }

    /**
     * Find orders in status shipped when they should be complete
     * @return array
     */
    public function loadOrders() {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderItemTable = $this->connection->getTableName('sales_order_item');
        $query = "SELECT o.entity_id, o.store_id, o.increment_id, o.state, o.`status`, SUM(oi.qty_shipped) AS shipped, SUM(oi.qty_invoiced) AS invoiced, SUM(oi.qty_ordered) AS ordered, SUM(oi.qty_canceled) AS canceled
FROM {$orderTable} o
INNER JOIN {$orderItemTable} oi ON o.entity_id = oi.order_id
WHERE o.state = 'processing' AND o.`status` = 'shipped'
GROUP BY o.entity_id
HAVING shipped > 0 AND invoiced > 0 AND canceled = 0
ORDER BY o.entity_id DESC";
        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }



}