<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

class PaymentReviewRectifier implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{

    const MAX_ADYEN_NOTIFICATION_AGE_TO_REPROCESS = 5; //days

    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource)
    {
        $this->connection = $resource->getConnection();
    }

    public function getInfo() {
        return "Fix order in payment_review status when its history says it should be another status";
    }

    public function getTitle() {
        return "Orders stuck in payment_review";
    }

    /**
     * Edit Adyen notification to make it process again
     * @param $order
     * @return bool
     * @throws \Exception
     */
    public function executeSingle($order) {
        //find adyen notification and set it to done=0
        $timeLimit = new \DateTime();
        $timeLimit->sub(new \DateInterval('P' . self::MAX_ADYEN_NOTIFICATION_AGE_TO_REPROCESS . 'D'));
        $adyenNotificationTable = $this->connection->getTableName('adyen_notification');
        $affectedRows = $this->connection->update(
            $adyenNotificationTable,
            ['done' => 0],
            ['merchant_reference = ?' => $order->increment_id, 'done = ?' => 1, 'event_code = ?' => 'AUTHORISATION', 'created_at > ?' => $timeLimit->format("Y-m-d H:i:s")]);
        return $affectedRows > 0;
    }

    /**
     * Find orders in payment_review that have their status different from what the latest status is in order history
     * @return array
     */
    public function loadOrders() {
        /* The query may need to be fixed to work with adyen 9 due to card order statuses */
        $orderTable = $this->connection->getTableName('sales_order');
        $orderHistoryTable = $this->connection->getTableName('sales_order_status_history');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');
        $query = "SELECT o.entity_id, o.increment_id, o.state, o.`status` AS order_status, oh.`status` AS history_status, oh.created_at
FROM {$orderTable} o
JOIN (
    SELECT b1.* FROM {$orderHistoryTable} b1
    JOIN
    (
      SELECT parent_id, MAX(entity_id) As maxDate
      FROM {$orderHistoryTable}
      GROUP BY parent_id
    ) b2
    ON b1.parent_id = b2.parent_id
    AND b1.entity_id = b2.maxDate
) oh
ON o.entity_id = oh.parent_id
INNER JOIN {$orderPaymentTable} op ON op.parent_id = o.entity_id AND op.method IN ('adyen_cc')
WHERE o.`status` = 'payment_review' AND o.`status` <> oh.`status`
ORDER BY o.entity_id DESC";
        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }



}