<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

class OrderExportedStatusUpdateRectifier  implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{
    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource)
    {
        $this->connection = $resource->getConnection();
    }

    public function getInfo() {
        return 'Updating order status in order_exported when status is confirmed or status is processing and payment method is paypal_express and status history is order_exported.';
    }

    public function getTitle() {
        return 'Manage status order update when status order history is order_exported';
    }

    /**
     * @param $order
     * @return bool
     */
    public function executeSingle($order) {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderGridTable = $this->connection->getTableName('sales_order_grid');

        $affectedRows = $this->connection->update(
            $orderTable,
            ['status' => 'order_exported'],
            ['entity_id = ?' => $order->entity_id, 'increment_id = ?' => $order->increment_id]);
        
        if($affectedRows > 0)
        {
            $affectedRows += $this->connection->update(
                $orderGridTable,
                ['status' => 'order_exported'],
                ['increment_id = ?' => $order->increment_id]);
        }

        return $affectedRows > 0;
    }

    public function loadOrders() {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderStatusHistoryTable = $this->connection->getTableName('sales_order_status_history');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');

        $query = "SELECT DISTINCT so.entity_id, so.increment_id
FROM {$orderTable} so
INNER JOIN (
    SELECT sh1.* FROM {$orderStatusHistoryTable} sh1
    JOIN 
    (
        SELECT parent_id, MAX(entity_id) as maxDate
		FROM {$orderStatusHistoryTable}
		GROUP BY parent_id
    ) sh2
    ON sh1.parent_id = sh2.parent_id
	AND sh1.entity_id = maxDate
) soh
ON so.entity_id = soh.parent_id
INNER JOIN {$orderPaymentTable} sop ON so.entity_id = sop.parent_id 
WHERE (
    so.`status` = 'confirmed'
    AND soh.`status` = 'order_exported')
OR (
    so.`status` = 'processing' 
    AND soh.`status` = 'order_exported' 
    AND sop.method = 'paypal_express')";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }
}