<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

class MissingPaymentInfoRectifier implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{

    const MAX_ADYEN_NOTIFICATION_AGE_TO_REPROCESS = 5; //days

    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource)
    {
        $this->connection = $resource->getConnection();
    }

    public function getInfo() {
        return "Fix order in order_exported status when adyen auth notification has been processed, but order state is still payment_review and payment data is missing.";
    }

    public function getTitle() {
        return "Orders stuck in order_exported missing payment info";
    }

    /**
     * Edit Adyen notification to make it process again
     * @param $order
     * @return bool
     * @throws \Exception
     */
    public function executeSingle($order) {
        //find adyen notification and set it to done=0
        $timeLimit = new \DateTime();
        $timeLimit->sub(new \DateInterval('P' . self::MAX_ADYEN_NOTIFICATION_AGE_TO_REPROCESS . 'D'));
        $adyenNotificationTable = $this->connection->getTableName('adyen_notification');
        $affectedRows = $this->connection->update(
            $adyenNotificationTable,
            ['done' => 0],
            ['merchant_reference = ?' => $order->increment_id, 'done = ?' => 1, 'event_code = ?' => 'AUTHORISATION', 'created_at > ?' => $timeLimit->format("Y-m-d H:i:s")]);
        return $affectedRows > 0;
    }

    /**
     * Find orders in order_exported that have their state still in payment_review and adyen payment info is missing
     * @return array
     */
    public function loadOrders() {
        /* The query may need to be fixed to work with adyen 9 due to card order statuses */
        $orderTable = $this->connection->getTableName('sales_order');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');
        $query = "SELECT o.increment_id, o.state, o.`status`
FROM {$orderTable} o
INNER JOIN {$orderPaymentTable} op ON o.entity_id = op.parent_id AND op.method = 'adyen_cc'
WHERE op.adyen_psp_reference IS NULL AND (
    (o.`status` = 'order_exported' AND o.state = 'payment_review') OR 
    (o.`status` = 'manual_review' AND o.state = 'new') OR
    (o.`status` = 'order_exported' AND o.state = 'processing' AND email_sent IS NULL)
)  
ORDER BY o.entity_id DESC";
        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }



}