<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

class InvoicedRectifier implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{

    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource)
    {
        $this->connection = $resource->getConnection();
    }

    public function getInfo() {
        return "Fix orders where invoice exists but order looks like it's not invoiced. All its *_invoiced fields are null.";
    }

    public function getTitle() {
        return "Fix invoiced orders";
    }

    /**
     * Fix order by setting the *_invoiced fields correctly
     * @param $order
     * @return bool
     * @throws \Exception
     */
    public function executeSingle($order) {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderId = $this->connection->fetchOne("SELECT o.entity_id
FROM {$orderTable} o
WHERE o.increment_id = ?", [$order->increment_id], \Zend_Db::FETCH_NUM);
        if ($orderId == FALSE) {
            throw new \Exception('Order ' . $order->increment_id . ' not found');
        }
        $this->connection->beginTransaction();
        try {
            $affectedRows = $this->connection->update(
                $orderTable,
                [
                    'base_discount_invoiced' => new \Zend_Db_Expr('base_discount_amount'),
                    'base_shipping_invoiced' => new \Zend_Db_Expr('base_shipping_amount'),
                    'base_subtotal_invoiced' => new \Zend_Db_Expr('base_subtotal'),
                    'base_tax_invoiced' => new \Zend_Db_Expr('base_tax_amount'),
                    'base_total_invoiced' => new \Zend_Db_Expr('base_grand_total'),
                    'discount_invoiced' => new \Zend_Db_Expr('discount_amount'),
                    'shipping_invoiced' => new \Zend_Db_Expr('shipping_amount'),
                    'subtotal_invoiced' => new \Zend_Db_Expr('subtotal'),
                    'tax_invoiced' => new \Zend_Db_Expr('tax_amount'),
                    'total_invoiced' => new \Zend_Db_Expr('grand_total'),
                    'discount_tax_compensation_invoiced' => new \Zend_Db_Expr('discount_tax_compensation_amount'),
                    'base_discount_tax_compensation_invoiced' => new \Zend_Db_Expr('base_discount_tax_compensation_amount'),
                    'base_customer_balance_invoiced' => new \Zend_Db_Expr('base_customer_balance_amount'),
                    'customer_balance_invoiced' => new \Zend_Db_Expr('customer_balance_amount'),
                    'base_gift_cards_invoiced' => new \Zend_Db_Expr('base_gift_cards_amount'),
                    'gift_cards_invoiced' => new \Zend_Db_Expr('gift_cards_amount'),
                    'gw_base_price_invoiced' => new \Zend_Db_Expr('gw_base_price'),
                    'gw_price_invoiced' => new \Zend_Db_Expr('gw_price'),
                    'gw_items_base_price_invoiced' => new \Zend_Db_Expr('gw_items_base_price'),
                    'gw_items_price_invoiced' => new \Zend_Db_Expr('gw_items_price'),
                    'gw_card_base_price_invoiced' => new \Zend_Db_Expr('gw_card_base_price'),
                    'gw_card_price_invoiced' => new \Zend_Db_Expr('gw_card_price'),
                    'gw_base_tax_amount_invoiced' => new \Zend_Db_Expr('gw_base_tax_amount'),
                    'gw_tax_amount_invoiced' => new \Zend_Db_Expr('gw_tax_amount'),
                    'gw_items_base_tax_invoiced' => new \Zend_Db_Expr('gw_items_base_tax_amount'),
                    'gw_items_tax_invoiced' => new \Zend_Db_Expr('gw_items_tax_amount'),
                    'gw_card_base_tax_invoiced' => new \Zend_Db_Expr('gw_card_base_tax_amount'),
                    'gw_card_tax_invoiced' => new \Zend_Db_Expr('gw_card_tax_amount'),
                    'base_total_paid' => new \Zend_Db_Expr('base_grand_total'),
                    'total_paid' => new \Zend_Db_Expr('grand_total'),
                    'base_total_due' => 0,
                    'total_due' => 0,
                ],
                ['increment_id = ?' => $order->increment_id]);
            $orderItemTable = $this->connection->getTableName('sales_order_item');
            $affectedRows += $this->connection->update(
                $orderItemTable,
                [
                    'qty_invoiced' => new \Zend_Db_Expr('qty_ordered'),
                    'tax_invoiced' => new \Zend_Db_Expr('tax_amount'),
                    'base_tax_invoiced' => new \Zend_Db_Expr('base_tax_amount'),
                    'discount_invoiced' => new \Zend_Db_Expr('discount_amount'),
                    'base_discount_invoiced' => new \Zend_Db_Expr('base_discount_amount'),
                    'row_invoiced' => new \Zend_Db_Expr('row_total'),
                    'base_row_invoiced' => new \Zend_Db_Expr('base_row_total'),
                    'discount_tax_compensation_invoiced' => new \Zend_Db_Expr('discount_tax_compensation_amount'),
                    'base_discount_tax_compensation_invoiced' => new \Zend_Db_Expr('base_discount_tax_compensation_amount'),
                    'gw_base_price_invoiced' => new \Zend_Db_Expr('gw_base_price'),
                    'gw_base_tax_amount_invoiced' => new \Zend_Db_Expr('gw_base_tax_amount'),
                    'gw_tax_amount_invoiced' => new \Zend_Db_Expr('gw_tax_amount'),
                    'gw_tax_amount_invoiced' => new \Zend_Db_Expr('gw_tax_amount'),
                ],
                ['order_id = ?' => $orderId]
            );
            $this->connection->commit();
        } catch (\Exception $e) {
            $this->connection->rollBack();
            throw $e;
        }
        return $affectedRows >= 2;
    }

    /**
     * Find orders with invoices that have base_total_invoiced == null and base_total_paid == null
     * @return array
     */
    public function loadOrders() {
        $orderTable = $this->connection->getTableName('sales_order');
        $invoiceTable = $this->connection->getTableName('sales_invoice');
        $query = "SELECT o.increment_id, o.state, o.`status`
FROM {$orderTable} o
INNER JOIN {$invoiceTable} i ON o.entity_id = i.order_id
WHERE o.base_total_invoiced IS NULL AND o.base_total_paid IS NULL 
ORDER BY o.entity_id DESC";
        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }



}