<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

class FixPayPalHppPaymentInfoRectifier implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{
    const MAX_ADYEN_NOTIFICATION_AGE_TO_REPROCESS = 5; //days

    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource
    )
    {
        $this->connection = $resource->getConnection();
    }

    public function getInfo()
    {
        return "Reprocessing adyen notification to update payments info on orders placed with paypal via adyen";
    }

    public function getTitle()
    {
        return "Update payments info for PayPal via Adyen orders";
    }

    public function executeSingle($order)
    {
        //find adyen notification and set it to done=0
        $timeLimit = new \DateTime();
        $timeLimit->sub(new \DateInterval('P' . self::MAX_ADYEN_NOTIFICATION_AGE_TO_REPROCESS . 'D'));
        $adyenNotificationTable = $this->connection->getTableName('adyen_notification');
        $affectedRows = $this->connection->update(
            $adyenNotificationTable,
            ['done' => 0],
            ['merchant_reference = ?' => $order->increment_id, 'done = ?' => 1, 'event_code = ?' => 'AUTHORISATION', 'created_at > ?' => $timeLimit->format("Y-m-d H:i:s")]);
        return $affectedRows > 0;
    }

    public function loadOrders()
    {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');
        $adyenNotification = $this->connection->getTableName('adyen_notification');

        $query = "SELECT o.increment_id, o.state, o.`status`
FROM {$orderTable} o
INNER JOIN {$orderPaymentTable} op ON o.entity_id = op.parent_id AND op.method = 'adyen_hpp' AND op.cc_type = 'paypal'
WHERE 
    (o.`status` = 'order_exported' AND o.state IN ('new', 'processing') AND op.adyen_psp_reference IS NULL) OR
    (o.`status` = 'pending' AND
     EXISTS (
         SELECT * FROM {$adyenNotification} an
         WHERE an.merchant_reference = o.increment_id AND an.event_code = 'AUTHORISATION')
    )  
ORDER BY o.entity_id DESC";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }
}