<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

use FiloBlu\OrderFlowRectifier\Api\RectifierInterface;
use Magento\Framework\App\State;
use Magento\Sales\Model\OrderRepository;

class ClearTestOrderRectifier implements RectifierInterface
{
    protected $connection;

    /**
     * @var OrderRepository
     */
    protected $orderRepository;

    /**
     * @var State
     */
    protected $state;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $connection,
        OrderRepository $orderRepository,
        State $state
    )
    {
        $this->connection = $connection->getConnection();
        $this->orderRepository = $orderRepository;
        $this->state = $state;
    }

    public function getInfo()
    {
        return 'Cancel test orders placed by automated tests. They are made by the test bot sistemi@filoblu.com';
    }

    public function getTitle()
    {
        return 'Cancel test orders placed by sistemi@filoblu.com';
    }

    public function executeSingle($order)
    {
        try {
            $this->state->getAreaCode();
        } catch (\Exception $ex) {
            $this->state->setAreaCode('crontab');
        }

        $affectedRows = 1;
        try {
            $salesOrder = $this->orderRepository->get($order->entity_id);
            $salesOrder->cancel();
            $salesOrder->addStatusHistoryComment('Cancel test order, processed by mod2-order-flow-rectifier.');
            $salesOrder->save();
        } catch (\Exception $e) {
            $affectedRows--;
        }

        return ($affectedRows == 1);
    }

    public function loadOrders()
    {
        $orderTable = $this->connection->getTableName('sales_order');
        $now = new \DateTime();
        $limitDate = $now->sub(new \DateInterval('PT1H'));

        $query = "SELECT o.increment_id, o.entity_id
FROM {$orderTable} o
WHERE 
      o.customer_email = 'sistemi@filoblu.com' AND
      o.status NOT IN ('canceled', 'canceled_by_ext') AND     
      o.created_at <= '".$limitDate->format('Y-m-d H:i:s')."'
ORDER BY o.entity_id DESC";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);

        return $ordersToBeRectified;
    }
}