<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

use FiloBlu\OrderFlowRectifier\Api\RectifierInterface;
use Magento\Framework\App\State;
use Magento\Sales\Model\OrderRepository;

class ClearPaymentAdditionlInfoRectifier implements RectifierInterface
{
    protected $connection;

    /**
     * @var OrderRepository
     */
    protected $orderRepository;

    /**
     * @var State
     */
    protected $state;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $connection,
        OrderRepository $orderRepository,
        State $state
    )
    {
        $this->connection = $connection->getConnection();
        $this->orderRepository = $orderRepository;
        $this->state = $state;
    }

    public function getInfo()
    {
        return 'Remove Klarna data if present from Additional Information on orders placed with other payment methods';
    }

    public function getTitle()
    {
        return 'Rectifier for clear Additional Information from Klarna data';
    }

    public function executeSingle($order)
    {
        try {
            $this->state->getAreaCode();
        } catch (\Exception $ex) {
            $this->state->setAreaCode('crontab');
        }

        $affectedRows = 1;
        try {
            $salesOrder = $this->orderRepository->get($order->entity_id);
            $payment = $salesOrder->getPayment();
            $additionalInfoData = $payment->getAdditionalInformation();
            if(!is_array($additionalInfoData)) {
                $additionalInfoData = json_decode($payment->getAdditionalInformation(), true);
            }

            if(isset($additionalInfoData['method_code']) && preg_match('/klarna*/', $additionalInfoData['method_code'])) {
                unset($additionalInfoData['method_code']);
                $payment->setAdditionalInformation($additionalInfoData);
                $this->orderRepository->save($salesOrder);
            }
        } catch (\Exception $e) {
            $affectedRows--;
        }

        return $affectedRows;
    }

    public function loadOrders()
    {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');
        $methodCode = '%"method_code":"klarna%';

        $query = "SELECT o.increment_id, o.entity_id
FROM {$orderTable} o
INNER JOIN {$orderPaymentTable} op ON o.entity_id = op.parent_id
WHERE
op.method != 'klarna_kp' AND op.additional_information LIKE '".$methodCode."'
ORDER BY o.entity_id DESC";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);

        return $ordersToBeRectified;
    }
}
