<?php

namespace FiloBlu\OrderFlowRectifier\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Logger\Handler\Base;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Store\Model\ScopeInterface;
use Monolog\Logger;

class OrderFlowLogger
{
    const LOG_ENABLED_CONFIG_PATH = 'order_flow_rectifier/general/enable_log';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var Base
     */
    private $logger;
    /**
     * @var Base
     */
    private $observerLogger;
    /**
     * @var SerializerInterface
     */
    private $serializer;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        Base                 $logger,
        Base                 $observerLogger,
        SerializerInterface  $serializer
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->logger = $logger;
        $this->observerLogger = $observerLogger;
        $this->serializer = $serializer;
    }

    /**
     * @param null|int|string $storeId
     * @return bool
     */
    public function logIsEnabled($storeId = null)
    {
        return $this->scopeConfig->isSetFlag(self::LOG_ENABLED_CONFIG_PATH, ScopeInterface::SCOPE_STORE, $storeId);
    }

    /**
     * @param array|string $data
     * @return array
     */
    protected function enrichData($data)
    {
        if (is_array($data)) {
            $data = $this->serializer->serialize($data);
        }
        return [
            'message' => $data,
            'datetime' => new \DateTime(),
            'channel' => 'filoblu_order_flow_rectifier',
            'level_name' => 'DEBUG',
            'level' => Logger::DEBUG,
            'context' => [],
            'extra' => []
        ];
    }

    /**
     * @param array|string $data
     * @param null|int|string $storeId
     */
    public function log($data, $storeId = null)
    {
        if ($this->logIsEnabled($storeId)) {
            $this->logger->handle($this->enrichData($data));
        }
    }

    /**
     * @param array|string $data
     * @param null|int|string $storeId
     */
    public function observerLog($data, $storeId = null)
    {
        if ($this->logIsEnabled($storeId)) {
            $this->observerLogger->handle($this->enrichData($data));
        }
    }
}
