<?php

namespace FiloBlu\OrderFlowRectifier\Helper;

use Magento\Framework\App\Helper\AbstractHelper;

class AdyenBankTransferHelper extends AbstractHelper
{
    const AUTOMATION_BANKTRANSFER_ORDER_ENABLED_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/automation_bank_transfer_order_enabled';
    const FIRST_NOTIFICATION_ENABLED_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/first_notification_enabled';
    const DAYS_TO_SEND_FIRST_NOTIFICATION_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/days_to_send_first_notification';
    const SECOND_NOTIFICATION_ENABLED_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/second_notification_enabled';
    const DAYS_TO_SEND_SECOND_NOTIFICATION_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/days_to_send_second_notification';
    const AUTOMATIC_CANCELLATION_ENABLED_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/automatic_cancellation_enabled';
    const DAYS_TO_DELETE_ORDER_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/days_to_delete_order';
    const MANUAL_REMINDER_BUTTON_ENABLE_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/manual_reminder_enabled';
    const MANUAL_REMINDER_BUTTON_ORDER_STATUS_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/order_status';
    const DATE_INDEX = 'date';
    const SENT_INDEX = 'sent';
    const NOTIFY_BANKTRANSFER_DATA = 'notify_banktransfer_data';
    const FIRST_REMINDER_INDEX = 'first_reminder';
    const SECOND_REMINDER_INDEX = 'second_reminder';
    const DELETE_ORDER_INDEX = 'delete_order';
    const BANKTRANSFER_REMAINDER_EMAIL_TEMPLATE_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/banktransfer_reminder_template';
    const PENDING_ORDERS_ONLY_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/pending_orders_only';
    const ORDER_STATUS_TO_HANDLE_PATH = 'order_flow_rectifier/adyen_bank_transfer_management/order_status_to_handle';

    public function automationBankTransferOrderIsEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::AUTOMATION_BANKTRANSFER_ORDER_ENABLED_PATH);
    }

    public function firstNotificationIsEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::FIRST_NOTIFICATION_ENABLED_PATH);
    }

    public function secondNotificationIsEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::SECOND_NOTIFICATION_ENABLED_PATH);
    }

    public function automaticOrderCancellationIsEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::AUTOMATIC_CANCELLATION_ENABLED_PATH);
    }

    public function daysToSendFirstNotification()
    {
        return $this->scopeConfig->getValue(self::DAYS_TO_SEND_FIRST_NOTIFICATION_PATH);
    }

    public function daysToSendSecondNotification()
    {
        return $this->scopeConfig->getValue(self::DAYS_TO_SEND_SECOND_NOTIFICATION_PATH);
    }

    public function daysToDeleteOrder()
    {
        return $this->scopeConfig->getValue(self::DAYS_TO_DELETE_ORDER_PATH);
    }

    public function manualReminderButtonIsEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::MANUAL_REMINDER_BUTTON_ENABLE_PATH);
    }

    public function manualReminderButtonOrderStatus()
    {
        if (is_null($this->scopeConfig->getValue(self::MANUAL_REMINDER_BUTTON_ORDER_STATUS_PATH))) {
            return [];
        }
        return explode(',', $this->scopeConfig->getValue(self::MANUAL_REMINDER_BUTTON_ORDER_STATUS_PATH));
    }

    public function calculateFirstNotifyDate()
    {
        $date = new \DateTime();
        $date->setTimezone(new \DateTimeZone('Europe/Rome'));
        $days = $this->daysToSendFirstNotification();
        $date->add(new \DateInterval('P' . $days . 'D'));
        return $date->format('Y-m-d');
    }

    public function calculateSecondNotifyDate()
    {
        $date = new \DateTime();
        $date->setTimezone(new \DateTimeZone('Europe/Rome'));
        $days = $this->daysToSendSecondNotification();
        $date->add(new \DateInterval('P' . $days . 'D'));
        return $date->format('Y-m-d');
    }

    public function calculateOrderCancellationDate()
    {
        $date = new \DateTime();
        $date->setTimezone(new \DateTimeZone('Europe/Rome'));
        $days = $this->daysToDeleteOrder();
        $date->add(new \DateInterval('P' . $days . 'D'));
        return $date->format('Y-m-d');
    }

    /**
     * @param array $data
     * @return bool
     */
    public function checkFirstReminder($data)
    {
        $result = false;

        if (!$this->firstNotificationIsEnabled()) {
            return $result;
        }

        if (!array_key_exists(self::FIRST_REMINDER_INDEX, $data)) {
            return $result;
        }

        $firstReminderData = $data[self::FIRST_REMINDER_INDEX];
        if (empty($firstReminderData)) {
            return $result;
        }

        if ($firstReminderData[self::SENT_INDEX] != 0) {
            return $result;
        }

        $now = new \DateTime();
        $now->setTimezone(new \DateTimeZone('Europe/Rome'));
        if ($now->format('Y-m-d') == $firstReminderData[self::DATE_INDEX]) {
            $result = true;
        }

        return $result;
    }

    /**
     * @param array $data
     * @return bool
     */
    public function checkSecondReminder($data)
    {
        $result = false;

        if (!$this->secondNotificationIsEnabled()) {
            return $result;
        }

        if (!array_key_exists(self::SECOND_REMINDER_INDEX, $data)) {
            return $result;
        }

        $secondReminderData = $data[self::SECOND_REMINDER_INDEX];
        if (empty($secondReminderData)) {
            return $result;
        }

        if ($secondReminderData[self::SENT_INDEX] != 0) {
            return $result;
        }

        $now = new \DateTime();
        $now->setTimezone(new \DateTimeZone('Europe/Rome'));
        if ($now->format('Y-m-d') == $secondReminderData[self::DATE_INDEX]) {
            $result = true;
        }

        return $result;
    }

    /**
     * @param array $data
     * @return bool
     */
    public function checkOrderDelete($data)
    {
        $result = false;

        if (!$this->automaticOrderCancellationIsEnabled()) {
            return $result;
        }

        if (!array_key_exists(self::DELETE_ORDER_INDEX, $data)) {
            return $result;
        }

        $deleteOrderData = $data[self::DELETE_ORDER_INDEX];
        if (empty($deleteOrderData)) {
            return $result;
        }

        $now = new \DateTime();
        $now->setTimezone(new \DateTimeZone('Europe/Rome'));
        if ($now->format('Y-m-d') == $deleteOrderData[self::DATE_INDEX]) {
            $result = true;
        }

        return $result;
    }

    /**
     * @return array|string|string[]
     */
    public function getOrderStausToHandle()
    {
        if ($this->scopeConfig->isSetFlag(self::PENDING_ORDERS_ONLY_PATH)) {
            return 'pending';
        }

        $orderStatusToHandle = $this->scopeConfig->getValue(self::ORDER_STATUS_TO_HANDLE_PATH);
        if (is_null($orderStatusToHandle) || empty($orderStatusToHandle)) {
            return 'pending';
        }
        return str_replace(",", "','", $orderStatusToHandle);
    }
}
