<?php


namespace FiloBlu\OrderFlowRectifier\Cron;

use Magento\Framework\App\Area;
use Magento\Framework\App\AreaList;
use Magento\Framework\App\State;

/**
 * Class CheckAdyenAuthorization
 *
 * @package FiloBlu\OrderFlowRectifier\Cron
 */
class AdyenBankTransferManagement
{
    /**
     * @var \FiloBlu\OrderFlowRectifier\Model\AdyenBankTransferManagement
     */
    protected $processor;

    /** @var State */
    protected $state;

    /** @var AreaList */
    private $areaList;

    /**
     * @param \FiloBlu\OrderFlowRectifier\Model\AdyenBankTransferManagement $processor
     * @param State $state
     * @param AreaList $areaList
     */
    public function __construct(
        \FiloBlu\OrderFlowRectifier\Model\AdyenBankTransferManagement $processor,
        State                                                         $state,
        AreaList                                                      $areaList
    )
    {
        $this->processor = $processor;
        $this->state = $state;
        $this->areaList = $areaList;
    }

    /**
     * Execute the cron
     *
     * @return void
     */
    public function execute()
    {
        if ($this->state->getAreaCode() == Area::AREA_CRONTAB) {
            $area = $this->areaList->getArea($this->state->getAreaCode());
            $area->load(Area::PART_TRANSLATE);
        }
        $this->processor->ManageBankTransferOrders();
    }
}

