<?php

namespace FiloBlu\OrderFlowRectifier\Controller\Adminhtml\Order;

use FiloBlu\OrderFlowRectifier\Helper\AdyenBankTransferHelper;
use FiloBlu\OrderFlowRectifier\Model\Order\Email\Sender\OrderSender;
use Magento\Sales\Api\OrderRepositoryInterface;

class SendPaymentReminder extends \Magento\Backend\App\Action
{
    /** @var OrderRepositoryInterface */
    protected $orderRepository;

    /** @var OrderSender */
    private $orderSender;

    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    private $resultPageFactory;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param OrderRepositoryInterface $orderRepository
     * @param OrderSender $orderSender
     */
    public function __construct(
        \Magento\Backend\App\Action\Context        $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        OrderRepositoryInterface                   $orderRepository,
        OrderSender                                $orderSender
    )
    {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->orderRepository = $orderRepository;
        $this->orderSender = $orderSender;
    }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $order = $this->getOrder();

        if ($order) {
            $payment = $order->getPayment();
            $payment->setAdditionalInformation(AdyenBankTransferHelper::FIRST_REMINDER_INDEX, '1');
            $sendReminder = $this->orderSender->sendReminder($order);
            if ($sendReminder) {
                $order->addCommentToStatusHistory('Bank Transfer Tool: manual reminder notification sent.');
                $this->messageManager->addSuccessMessage(__('Bank transfer payment reminder notification sent.'));
            } else {
                $order->addCommentToStatusHistory('Bank Transfer Tool: manual reminder notification not sent.');
                $this->messageManager->addErrorMessage(__('Error sending bank transfer payment reminder notification. Try again!'));
            }
            $payment->unsAdditionalInformation(AdyenBankTransferHelper::FIRST_REMINDER_INDEX);
            $this->orderRepository->save($order);

            $resultRedirect->setPath('sales/order/view', ['order_id' => $order->getEntityId()]);
            return $resultRedirect;
        }

        $resultRedirect->setPath('sales/*/');
        return $resultRedirect;
    }

    /**
     * @return false|\Magento\Sales\Api\Data\OrderInterface
     */
    protected function getOrder()
    {
        $id = $this->getRequest()->getParam('order_id');
        try {
            $order = $this->orderRepository->get($id);
        } catch (NoSuchEntityException $e) {
            $this->messageManager->addErrorMessage(__('This order no longer exists.'));
            $this->_actionFlag->set('', self::FLAG_NO_DISPATCH, true);
            return false;
        } catch (InputException $e) {
            $this->messageManager->addErrorMessage(__('This order no longer exists.'));
            $this->_actionFlag->set('', self::FLAG_NO_DISPATCH, true);
            return false;
        }
        return $order;
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_OrderFlowRectifier::config_filoblu_orderflowrectifier_manual_reminder_button');
    }
}
