<?php


namespace FiloBlu\OrderFlowRectifier\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class Rectifiers
 *
 * @package FiloBlu\OrderFlowRectifier\Console\Command
 */
class Rectifiers extends Command
{

    protected $rectifierPoolFactory;

    public function __construct(
        \FiloBlu\OrderFlowRectifier\Model\RectifierPoolFactory $rectifierPoolFactory
    )
    {
        $this->rectifierPoolFactory = $rectifierPoolFactory;
        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(
        InputInterface $input,
        OutputInterface $output
    ) {
        $rectifiers = $this->rectifierPoolFactory->create()->getList();
        $rectifiersCount = count($rectifiers);
        $output->writeln('<info>Found ' . $rectifiersCount . ' rectifier(s)</info>');
        $counter = 1;
        foreach ($rectifiers as $name => $rectifier) {
            $output->writeln('<info>' . $counter .'/' . $rectifiersCount . ': ' . $name .' (' . $rectifier->getTitle() . ')</info>');
            $counter++;
        }
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this->setName("filoblu:orderflowrectifier:list");
        $this->setDescription("List all available rectifiers");
        parent::configure();
    }
}
