<?php

namespace FiloBlu\OrderFlowRectifier\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

/**
 *
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * @param \Magento\Framework\Setup\SchemaSetupInterface $setup
     * @param \Magento\Framework\Setup\ModuleContextInterface $context
     * @return void
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.0.1') < 0) {
            // Get module table
            $tableName = $setup->getTable('sales_order');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName)) {
                // Declare data
                $columns = [
                    'offline_payment_email_sent' => [
                        'type' => Table::TYPE_SMALLINT ,
                        'length' => '5',
                        'nullable' => false,
                        'unsigned' => true,
                        'default'  => 0,
                        'comment' => 'Payment Offline Email Sent' ,
                    ] ,
                ];

                $connection = $setup->getConnection();

                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
        }

        $setup->endSetup();
    }
}
