<?php

namespace FiloBlu\OrderFlowRectifier\Observer\Sales;

use FiloBlu\OrderFlowRectifier\Helper\Data;
use FiloBlu\OrderFlowRectifier\Helper\OrderFlowLogger;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class OrderPlaceBeforeAbstract implements ObserverInterface
{
    protected $dataHelper;
    protected $logger;

    public function __construct(
        Data $dataHelper,
        OrderFlowLogger $logger
    ) {
        $this->dataHelper = $dataHelper;
        $this->logger = $logger;
    }

    protected function checkQuote(Observer $observer, $payPalOrder = false)
    {
        if($payPalOrder)
        {
            $quote = $observer->getEvent()->getQuote();
            $quoteId = $quote->getId();
        }
        else
        {
            $order = $observer->getEvent()->getOrder();
            $quoteId = $order->getQuoteId();
        }

        $quoteItem = $this->dataHelper->getQuoteItem($quoteId);
        $missingQuoteChildren = $this->dataHelper->checkQuoteItem($quoteItem, $quoteId);

        return $missingQuoteChildren;
    }

    public function execute(Observer $observer)
    {}
}
