<?php

namespace FiloBlu\OrderFlowRectifier\Observer;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class CheckForInvoiceCreation implements ObserverInterface
{
    const SCHEDULED_CHECK_INVOICE_CREATION_ENABLED_CONFIG_PATH = 'order_flow_rectifier/general/scheduled_check_invoice_creations_enabled';

    /**
     * @var ScopeConfigInterface
     */
    protected $config;

    public function __construct(
        ScopeConfigInterface $config
    )
    {
        $this->config = $config;
    }

    /**
     * @param Observer $observer
     * @return bool
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute(Observer $observer)
    {
        if ($this->config->isSetFlag(self::SCHEDULED_CHECK_INVOICE_CREATION_ENABLED_CONFIG_PATH))
        {
            $invoice = $observer->getEvent()->getInvoice();
            $order = $invoice->getOrder();
            $orderPayment = $order->getPayment();

            $method = $orderPayment->getMethod();
            $ccType = $orderPayment->getCcType();
            $additionalInformation = $orderPayment->getAdditionalInformation();
            $ccLast4 = $orderPayment->getCcLast4();
            $ccTransId = $orderPayment->getCcTransId();
            $adyenPspReference = $orderPayment->getAdyenPspReference();

            if($method == 'adyen_hpp' && in_array($ccType, ['klarna', 'klarna_account', 'klarna_paynow']))
            {
                if(is_null($ccTransId) || is_null($adyenPspReference) ||
                    !isset($additionalInformation['pspReference']) ||
                    is_null($additionalInformation['pspReference']))
                {
                    throw new \Magento\Framework\Exception\LocalizedException(__("Payment information incomplete. Invoice creation not allowed!"));
                }
            }
            elseif (in_array($method, ['adyen_cc', 'adyen_oneclick']))
            {
                if(is_null($ccTransId) || is_null($adyenPspReference) || is_null($ccLast4) ||
                    !isset($additionalInformation['pspReference']) ||
                    is_null($additionalInformation['pspReference']))
                {
                    throw new \Magento\Framework\Exception\LocalizedException(__("Payment information incomplete. Invoice creation not allowed!"));
                }
            }
        }

        return true;
    }
}