<?php

namespace FiloBlu\OrderFlowRectifier\Observer;

use FiloBlu\OrderFlowRectifier\Helper\Data;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;

/**
 * Observer on Adyen notification to get cc_type value and update it in table sales_order_payment if missing
 * or fix it if payment is made by Klarna via Adyen
 * This observer needs the adyen module to be patched at least with adyen_notification_events_4303_update.patch
 */

class CancelTestOrdersWithCreditCard implements ObserverInterface
{
    /**
     * @var ScopeConfigInterface
     */
    protected $config;

    public function __construct(
        ScopeConfigInterface $config
    )
    {
        $this->config = $config;
    }

    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        if (!$this->config->isSetFlag(Data::SCHEDULED_CANCEL_TEST_ORDER_CC_ENABLED_CONFIG_PATH)) {
            return;
        }

        $order = $observer->getEvent()->getOrder();
        $orderPayment = $order->getPayment();
        $paymentMethod = $orderPayment->getMethod();

        if ($paymentMethod != 'adyen_cc'
            || $order->getCustomerEmail() != 'sistemi@filoblu.com'
            || $observer->getEvent()->getNotificationCode() != 'AUTHORISATION') {
            return;
        }

        if (!$order->canCancel()) {
            $order->setState(Order::STATE_NEW);
        }

        $order->cancel();
        $order->addCommentToStatusHistory(__('Test order sistemifiloblu.com cancelled'));
    }
}
