<?php

namespace FiloBlu\OrderFlowRectifier\Observer;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class CancelOrderForRefusedKlarnaPayments implements ObserverInterface
{
    const SCHEDULED_CANCEL_REFUSED_KLARNA_ENABLED_CONFIG_PATH = 'order_flow_rectifier/general/scheduled_cancel_refused_klarna_enabled';
    const ADYEN_NOTIFICATION_EVENT_CODE = 'AUTHORISATION';

    /**
     * @var ScopeConfigInterface
     */
    protected $config;

    public function __construct(
        ScopeConfigInterface $config
    )
    {
        $this->config = $config;
    }
    
    public function execute(Observer $observer)
    {
        if ($this->config->isSetFlag(self::SCHEDULED_CANCEL_REFUSED_KLARNA_ENABLED_CONFIG_PATH))
        {
            $order = $observer->getEvent()->getOrder();
            $orderPayment = $order->getPayment();
            $eventCode = $observer->getEvent()->getNotificationCode();
            $method = $orderPayment->getMethod();
            $ccType = $orderPayment->getCcType();
            
            if($eventCode == self::ADYEN_NOTIFICATION_EVENT_CODE && $method == 'adyen_hpp'
               && in_array($ccType, ['klarna', 'klarna_account', 'klarna_paynow']))
            {
                $order->cancel();
                $order->addStatusHistoryComment('Payment refused from adyen. Order processed by mod2-order-flow-rectifier.');
                $order->save();
            }
        }

        return true;
    }
}