<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

class PaymentReviewStateRectifier implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{

    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource)
    {
        $this->connection = $resource->getConnection();
    }

    public function getInfo() {
        return "Fix order paid with adyen_cc with state in payment_review and status order_exported, while state should be processing";
    }

    public function getTitle() {
        return "State in payment_review and status order_exported";
    }

    /**
     * Set order state to processing
     * @param $order
     * @return bool
     * @throws \Exception
     */
    public function executeSingle($order) {
        $orderTable = $this->connection->getTableName('sales_order');
        $affectedRows = $this->connection->update(
            $orderTable = $this->connection->getTableName('sales_order'),
            ['state' => 'processing'],
            ['entity_id = ?' => $order->entity_id]);
        return $affectedRows > 0;
    }

    /**
     * Find orders paid with adyen_cc in order_exported status that have their state stuck in payment_review, while it should be processing.
     * Payment information is good.
     * @return array
     */
    public function loadOrders() {
        /* The query may need to be fixed to work with adyen 9 due to card order statuses */
        $orderTable = $this->connection->getTableName('sales_order');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');
        $query = "SELECT o.increment_id, o.state, o.`status`, o.entity_id
FROM {$orderTable} o
INNER JOIN {$orderPaymentTable} op ON o.entity_id = op.parent_id AND op.method IN ('adyen_cc', 'adyen_oneclick', 'adyen_apple_pay')
WHERE op.adyen_psp_reference IS NOT NULL AND o.`status` = 'order_exported' AND o.state = 'payment_review'
ORDER BY o.entity_id DESC";
        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }



}
