<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

use Magento\Framework\App\State;
use Magento\Sales\Model\OrderRepository;

class OrderExportedBackToConfirmedRectifier implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{
    const HISTORY_MESSAGE_TO_CHECK = 'Empty list recurring contracts';
    const HISTORY_EVENT_CODE_TO_CHECK = 'RECURRING_CONTRACT';
    protected $connection;

    /**
     * @var OrderRepository
     */
    protected $orderRepository;

    /**
     * @var State
     */
    protected $state;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource,
        OrderRepository $orderRepository,
        State $state)
    {
        $this->connection = $resource->getConnection();
        $this->orderRepository = $orderRepository;
        $this->state = $state;
    }

    public function getInfo() {
        return 'Updating order status in order_exported when status is back to confirmed with adyen event RECURRING_CONTRACT and message Empty list recurring contracts.';
    }

    public function getTitle() {
        return 'Manage status order update when status order is back from order_exported to confirmed';
    }

    /**
     * @param $order
     * @return bool
     */
    public function executeSingle($order) {
        try {
            $this->state->getAreaCode();
        } catch (\Exception $ex) {
            $this->state->setAreaCode('crontab');
        }

        $result = true;
        try {
            $salesOrder = $this->orderRepository->get($order->entity_id);
            $salesOrder->setStatus('order_exported');
            $salesOrder->addStatusHistoryComment('Order processed by mod2-order-flow-rectifier');
            $salesOrder->save();
        } catch (\Exception $e) {
            $result = false;
        }

        return $result;
    }

    public function loadOrders() {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderStatusHistoryTable = $this->connection->getTableName('sales_order_status_history');

        $query = "SELECT DISTINCT so.entity_id, so.increment_id
FROM {$orderTable} so
INNER JOIN (
    SELECT sh1.* FROM {$orderStatusHistoryTable} sh1
    JOIN 
    (
        SELECT parent_id, MAX(entity_id) as maxDate
		FROM {$orderStatusHistoryTable}
		GROUP BY parent_id
    ) sh2
    ON sh1.parent_id = sh2.parent_id
	AND sh1.entity_id = maxDate
    AND (sh1.comment LIKE '%".self::HISTORY_MESSAGE_TO_CHECK."%'
    OR sh1.comment LIKE '%".self::HISTORY_EVENT_CODE_TO_CHECK."%')
) soh
ON so.entity_id = soh.parent_id
INNER JOIN {$orderStatusHistoryTable} soh2 ON so.entity_id = soh2.parent_id
AND soh2.status = 'order_exported'
WHERE so.status = 'confirmed' AND so.status = soh.status
ORDER BY so.entity_id DESC";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }
}