<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

use FiloBlu\OrderFlowRectifier\Api\RectifierInterface;
use Magento\Framework\App\State;

class FixFakeAdyenKlarnaCcType implements RectifierInterface
{
    protected $connection;

    /**
     * @var State
     */
    protected $state;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $connection,
        State $state
    )
    {
        $this->connection = $connection->getConnection();
        $this->state = $state;
    }

    public function getInfo()
    {
        return 'Fix cc_type if it is klarna via adyen and method is different';
    }

    public function getTitle()
    {
        return 'Fix fake Klarna cc_type';
    }

    public function executeSingle($order)
    {
        try {
            $this->state->getAreaCode();
        } catch (\Exception $ex) {
            $this->state->setAreaCode('crontab');
        }

        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');
        $orderTableGrid = $this->connection->getTableName('sales_order_grid');

        $affectedRows = $this->connection->update(
            $orderPaymentTable,
            ['cc_type' => null],
            ['entity_id = ?' => $order->entity_id]);

        if($affectedRows > 0)
        {
            $affectedRows += $this->connection->update(
                $orderTableGrid,
                ['payment_cctype' => null],
                ['increment_id = ?' => $order->increment_id]);
        }

        return $affectedRows > 0;
    }

    public function loadOrders()
    {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');

        $query = "SELECT so.increment_id, sop.entity_id
FROM {$orderTable} so
INNER JOIN {$orderPaymentTable} sop ON so.entity_id = sop.parent_id
WHERE 
    sop.cc_type LIKE '%klarna%' AND sop.method NOT IN ('adyen_hpp', 'klarna_kp')";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }
}