<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

use Magento\Framework\App\State;
use Magento\Sales\Model\OrderRepository;

class ConfirmedStatusUpdateRectifier implements \FiloBlu\OrderFlowRectifier\Api\RectifierInterface
{
    protected $connection;

    /**
     * @var OrderRepository
     */
    protected $orderRepository;

    /**
     * @var State
     */
    protected $state;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource,
        OrderRepository $orderRepository,
        State $state
    )
    {
        $this->connection = $resource->getConnection();
        $this->orderRepository = $orderRepository;
        $this->state = $state;
    }

    public function getInfo() {
        return 'Updating order status in confirmed when status is processing, status history is confirmed and payment method is paypal';
    }

    public function getTitle() {
        return 'Status order in processing and status order history in confirmed';
    }

    public function executeSingle($order) {
        try {
            $this->state->getAreaCode();
        } catch (\Exception $ex) {
            $this->state->setAreaCode('crontab');
        }

        $result = true;
        try {
            $salesOrder = $this->orderRepository->get($order->entity_id);
            $salesOrder->setStatus('confirmed')->save();
        } catch (\Exception $e) {
            $result = false;
        }

        return $result;
    }

    public function loadOrders() {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderStatusHistoryTable = $this->connection->getTableName('sales_order_status_history');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');

        $query = "SELECT DISTINCT so.entity_id, so.increment_id
FROM {$orderTable} so
INNER JOIN (
    SELECT sh1.* FROM {$orderStatusHistoryTable} sh1
    JOIN 
    (
        SELECT parent_id, MAX(entity_id) as maxDate
		FROM {$orderStatusHistoryTable}
		GROUP BY parent_id
    ) sh2
    ON sh1.parent_id = sh2.parent_id
	AND sh1.entity_id = maxDate
) soh
ON so.entity_id = soh.parent_id
INNER JOIN {$orderPaymentTable} sop ON so.entity_id = sop.parent_id 
AND sop.method = 'paypal_express'
WHERE so.`status` = 'processing' AND soh.`status` = 'confirmed'";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }
}