<?php


namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

use FiloBlu\OrderFlowRectifier\Api\RectifierInterface;

class CompleteKlarnaPaymentsDetailsRectifier implements RectifierInterface
{
    const AUTHORIZED_PAYMENT_METHOD = 'authorized_payment_method';
    const MAPPED_KLARNA_PAYMENT = [
        'direct_bank_transfer' => 'klarna_paynow',
        'slice_it_by_card' => 'klarna_payinthree',
        'invoice' => 'klarna_paylater',
        'pix' => 'klarna_financing',
        'direct_debit' => 'klarna_paynow',
        'card' => 'klarna_paynow',
        'fixed_amount' => 'klarna_financing',
        'base_account' => 'klarna_financing',
        'pay_by_card' => 'klarna_paynow',
        'fixed_sum_credit' => 'klarna_financing',
        'alternative_payment_method' => 'klarna_paynow',
        'pay_later_by_card' => 'klarna_paylater'
    ];
    protected $connection;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $connection
    )
    {
        $this->connection = $connection->getConnection();
    }

    public function getInfo()
    {
        return 'Update Klarna payments details with method code name';
    }

    public function getTitle()
    {
        return 'Complete Klarna Payments Details';
    }

    public function executeSingle($order)
    {
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');
        $orderTableGrid = $this->connection->getTableName('sales_order_grid');
        $payment_additional_information = json_decode($order->additional_information, true);
        $affectedRows = 0;

        /*
         * NOTE: For using this fix in the project must be applied the
         * "klarna_add_authorized_payment_method_on_additional_info_v6_new.patch" or
         * "klarna_add_authorized_payment_method_on_additional_info_v7_new.patch" patch,
         * depending on klarna/module-kp module version.
         */
        if(!is_null($payment_additional_information) && isset($payment_additional_information[self::AUTHORIZED_PAYMENT_METHOD]))
        {
            if(isset(self::MAPPED_KLARNA_PAYMENT[$payment_additional_information[self::AUTHORIZED_PAYMENT_METHOD]]))
            {
                $affectedRows = $this->connection->update(
                    $orderPaymentTable,
                    ['cc_type' => self::MAPPED_KLARNA_PAYMENT[$payment_additional_information[self::AUTHORIZED_PAYMENT_METHOD]]],
                    ['parent_id = ?' => $order->entity_id]);

                if($affectedRows > 0)
                {
                    $affectedRows += $this->connection->update(
                        $orderTableGrid,
                        ['payment_cctype' => self::MAPPED_KLARNA_PAYMENT[$payment_additional_information[self::AUTHORIZED_PAYMENT_METHOD]]],
                        ['increment_id = ?' => $order->increment_id]);
                }
            }
        }

        return $affectedRows > 0;
    }

    public function loadOrders()
    {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');

        $query = "SELECT so.entity_id, so.increment_id, sop.method, sop.additional_information
FROM {$orderTable} so
INNER JOIN {$orderPaymentTable} sop ON so.entity_id = sop.parent_id
WHERE
      sop.method IN ('klarna_kp') AND
      (sop.cc_type IS NULL OR sop.cc_type NOT LIKE '%klarna%')";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);
        return $ordersToBeRectified;
    }
}
