<?php

namespace FiloBlu\OrderFlowRectifier\Model\Rectifiers;

use FiloBlu\OrderFlowRectifier\Api\RectifierInterface;
use Magento\Framework\App\State;
use Magento\Sales\Model\OrderRepository;

class ClearPayPalHppOrderRectifier implements RectifierInterface
{
    protected $connection;

    /**
     * @var OrderRepository
     */
    protected $orderRepository;

    /**
     * @var State
     */
    protected $state;

    public function __construct(
        \Magento\Framework\App\ResourceConnection $connection,
        OrderRepository $orderRepository,
        State $state
    )
    {
        $this->connection = $connection->getConnection();
        $this->orderRepository = $orderRepository;
        $this->state = $state;
    }

    public function getInfo()
    {
        return 'Cancel orders made with PayPal via Adyen still in pendig and without adyen notification or authorisation';
    }

    public function getTitle()
    {
        return 'Rectifier for clear PayPal via Adyen Hpp orders';
    }

    public function executeSingle($order)
    {
        try {
            $this->state->getAreaCode();
        } catch (\Exception $ex) {
            $this->state->setAreaCode('crontab');
        }

        $affectedRows = 1;
        try {
            $salesOrder = $this->orderRepository->get($order->entity_id);
            $salesOrder->cancel();
            $salesOrder->addStatusHistoryComment('Order payment not completed, processed by mod2-order-flow-rectifier.');
            $salesOrder->save();
        } catch (\Exception $e) {
            $affectedRows--;
        }

        return $affectedRows;
    }

    public function loadOrders()
    {
        $orderTable = $this->connection->getTableName('sales_order');
        $orderPaymentTable = $this->connection->getTableName('sales_order_payment');
        $adyenNotification = $this->connection->getTableName('adyen_notification');
        $now = new \DateTime();
        $limitDate = $now->sub(new \DateInterval('PT13H'));

        $query = "SELECT o.increment_id, o.entity_id
FROM {$orderTable} o
INNER JOIN {$orderPaymentTable} op ON o.entity_id = op.parent_id
AND op.method IN ('adyen_hpp') AND op.cc_type IN ('paypal')
WHERE 
      NOT EXISTS (
          SELECT * FROM {$adyenNotification} an
          WHERE 
          an.merchant_reference = o.increment_id AND an.event_code = 'AUTHORISATION'
      ) AND
      o.status = 'pending' AND     
      o.created_at <= '".$limitDate->format('Y-m-d H:i:s')."'
ORDER BY o.entity_id DESC";

        $ordersToBeRectified = $this->connection->fetchAll($query, [], \Zend_Db::FETCH_OBJ);

        return $ordersToBeRectified;
    }
}