<?php


namespace FiloBlu\OrderFlowRectifier\Model;


use FiloBlu\OrderFlowRectifier\Api\RectifierInterface;
use Magento\Framework\Exception\NotFoundException;

class RectifierPool
{

    /**
     * @var RectifierInterface[]
     */
    private $rectifiers;

    /**
     * @param array $rectifiers
     */
    public function __construct(
        array $rectifiers = []
    ) {

        $this->rectifiers = $rectifiers;
    }

    /**
     * @return array|RectifierInterface[]
     */
    public function getList() {
        return $this->rectifiers;
    }


    /**
     * Retrieves operation
     *
     * @param string $rectifierCode
     * @return RectifierInterface
     * @throws NotFoundException
     */
    public function get($rectifierCode)
    {
        if (!isset($this->rectifiers[$rectifierCode])) {
            throw new NotFoundException(
                __('The "%1" rectifier doesn\'t exist. Verify the order rectifier and try again.', $rectifierCode)
            );
        }

        return $this->rectifiers[$rectifierCode];
    }

}