<?php

namespace FiloBlu\OrderFlowRectifier\Model;

use FiloBlu\OrderFlowRectifier\Helper\OrderFlowLogger;

class Processor extends \Magento\Framework\Model\AbstractModel
{

    const MAX_ORDER_TO_PROCESS = 10;
    const ENABLED_RECTIFIERS_CONFIG_PATH = 'order_flow_rectifier/general/enabled_rectifiers';

    /**
     * @var RectifierPoolFactory
     */
    protected $rectifierPoolFactory;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $config;

    /**
     * @var OrderFlowLogger
     */
    protected $logger;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        RectifierPoolFactory $rectifierPoolFactory,
        \Magento\Framework\App\Config\ScopeConfigInterface $config,
        OrderFlowLogger $logger,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = [])
    {
        parent::__construct(
            $context, $registry, $resource, $resourceCollection, $data);

        $this->rectifierPoolFactory = $rectifierPoolFactory;
        $this->config = $config;
        $this->logger = $logger;
    }

    public function process() {
        $rectifiers = $this->rectifierPoolFactory->create()->getList();
        $enabledRectifiers = $this->config->getValue(self::ENABLED_RECTIFIERS_CONFIG_PATH);
        $enabledRectifiers = array_map('trim', explode(',', $enabledRectifiers));
        foreach ($rectifiers as $code => $rectifier) {
            if (!in_array($code, $enabledRectifiers)) {
                continue;
            }
            $ordersToProcess = $rectifier->loadOrders();
            if (count($ordersToProcess) > self::MAX_ORDER_TO_PROCESS) {
                $this->logger->log('Running rectifier "' . $rectifier->getTitle() . '" on ' . self::MAX_ORDER_TO_PROCESS . ' of ' . count($ordersToProcess) . ' orders');
            } else {
                $this->logger->log('Running rectifier "' . $rectifier->getTitle() . '" on ' . count($ordersToProcess) . ' orders');
            }
            $processedCount = 0;
            foreach ($ordersToProcess as $order) {
                if ($processedCount > self::MAX_ORDER_TO_PROCESS) {
                    break;
                }
                $this->logger->log('Processing order ' . $order->increment_id);
                $success = $rectifier->executeSingle($order);
                if ($success) {
                    $this->logger->log('Done');
                } else {
                    $this->logger->log('Not done');
                }
                $processedCount++;
            }
        }
        $this->logger->log('END RECTIFY PROCESS');
    }

}
