<?php
/**
 * Created by PhpStorm.
 * User: ebaschiera
 * Date: 30/03/20
 * Time: 8.56
 */

namespace FiloBlu\OrderFlowRectifier\Model\Config\Source;

class Rectifiers implements \Magento\Framework\Option\ArrayInterface
{

    /**
     * @var \FiloBlu\OrderFlowRectifier\Model\RectifierPoolFactory
     */
    protected $rectifierPoolFactory;


    /**
     * Rectifiers constructor.
     * @param \FiloBlu\OrderFlowRectifier\Model\RectifierPoolFactory $rectifierPoolFactory
     */
    public function __construct(
        \FiloBlu\OrderFlowRectifier\Model\RectifierPoolFactory $rectifierPoolFactory
    ) {
        $this->rectifierPoolFactory = $rectifierPoolFactory;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $rectifiers = $this->rectifierPoolFactory->create()->getList();

        foreach ($rectifiers as $code => $rectifier) {
            $options[] = ['value' => $code, 'label' => $rectifier->getTitle()];
        }
        return $options;
    }
}
