<?php


namespace FiloBlu\OrderFlowRectifier\Cron;

/**
 * Class Rectifier
 *
 * @package FiloBlu\OrderFlowRectifier\Cron
 */
class Rectifier
{

    const SCHEDULED_OPERATIONS_ENABLED_CONFIG_PATH = 'order_flow_rectifier/general/scheduled_ops_enabled';

    /**
     * @var \FiloBlu\OrderFlowRectifier\Model\ProcessorFactory
     */
    protected $processorFactory;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $config;

    /**
     * Rectifier constructor.
     * @param \FiloBlu\OrderFlowRectifier\Model\ProcessorFactory $processorFactory
     */
    public function __construct(
        \FiloBlu\OrderFlowRectifier\Model\ProcessorFactory $processorFactory,
        \Magento\Framework\App\Config\ScopeConfigInterface $config
    )
    {
        $this->processorFactory = $processorFactory;
        $this->config = $config;
    }

    /**
     * Execute the cron
     *
     * @return void
     */
    public function execute()
    {
        if ($this->config->isSetFlag(self::SCHEDULED_OPERATIONS_ENABLED_CONFIG_PATH)) {
            $this->processorFactory->create()->process();
        }
    }
}

