define([
    "jquery",
    "jquery/ui",
    "mage/cookies",
    "prototype"
], function ($) {
    "use strict";

    //creating jquery widget
    $.widget('filoblu.newsletter_landing', {
        _create: function () {

            var options = this.options;
            var me = this;

            $(options.submit_btn).on("click", function () {
                me.removeMsg($(options.container_id), 'error-msg');
                if ($(options.submit_form).valid()) {

                    $.ajax({
                        showLoader: true,
                        url: $(options.submit_form).attr("action"),
                        data: $(options.submit_form).serialize(),
                        type: "POST",
                        dataType: 'json'
                    }).done(function (result) {

                        if (result) {
                            if (result.success) {

                                if (!$.mage.cookies.get(options.cookie_name)) {
                                    var toDay = new Date();//for getting todays date.
                                    toDay.setTime(toDay.getTime());
                                    var expaireTime = options.cookie_duration * 1000;
                                    var expaireDate = new Date(toDay.getTime() + (expaireTime));

                                    $.mage.cookies.set(options.cookie_name, 'subscribed', {"expires": expaireDate});
                                }

                                if (window.ga) {
                                    window.ga('send',
                                            {hitType: 'event', eventCategory: 'Newsletter', eventAction: 'click', eventLabel: 'Edit newsletter landing ' + options.code}
                                    );
                                }

                                window.dataLayer = window.dataLayer || [];
                                dataLayer.push({
                                    'event': 'newsletter',
                                    'newsletter': {
                                        'category': 'Newsletter',
                                        'action': 'click',
                                        'label': 'Edit newsletter landing ' + options.code
                                    }
                                });

                                me.addMsg($(options.container_id), result.message, 'success-msg');

                                window.location.href = result.redirect;

                            } else {
                                me.addMsg($(options.container_id), result.message, 'error-msg');
                            }

                        }

                    });
                }
            });


        },
        addMsg: function (block, message, messageClass) {
            if (typeof (message) === 'object' && message.length > 0) {
                message.each(function (msg) {
                    this._appendMessage(block, msg, messageClass);
                }.bind(this));
            } else if (typeof (message) === 'string') {
                this._appendMessage(block, message, messageClass);
            }
        },
        _appendMessage: function (block, message, messageClass) {
            var currentMessage = null;
            var messageSection = block.find("." + messageClass + " ol");
            if (messageSection.length === 0) {
                var messageElement = new Element('div');
                messageElement.addClassName(messageClass);
                messageElement.appendChild(new Element('ol'));
                block.append(messageElement);
                currentMessage = messageElement.down();
                var newMessage = new Element('li');
                newMessage.update(message);
                currentMessage.appendChild(newMessage);
            } else {
                currentMessage = messageSection.first();
                var newMessage = new Element('li');
                newMessage.update(message);
                currentMessage.append(newMessage);
            }

        },
        removeMsg: function (block, messageClass) {

            block.find('.' + messageClass).each(function (index, el) {
                el.remove();
            });
        }

    });

    return $.filoblu.newsletter_landing;
});