<?php

namespace FiloBlu\Newsletter\Setup;

use Exception;
use Magento\Cms\Model\BlockFactory;
use Magento\Customer\Model\Customer;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\App\State;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Eav\Model\Config;

class UpgradeData implements UpgradeDataInterface
{

    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;
    /**
     * @var BlockFactory
     */
    private $blockFactory;
    /**
     * @var Config
     */
    private $eavConfig;

    public function __construct(
        EavSetupFactory $eavSetupFactory,
        Config          $eavConfig,
        BlockFactory    $blockFactory,
        State           $state
    )
    {
        try {
            $state->getAreaCode();
        } catch (Exception $ex) {
            $state->setAreaCode('adminhtml');
        }
        $this->eavSetupFactory = $eavSetupFactory;
        $this->eavConfig = $eavConfig;
        $this->blockFactory = $blockFactory;
    }

    /**
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     * @throws LocalizedException
     */
    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        if (version_compare($context->getVersion(), '1.0.5') < 0) {
            $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
            $eavSetup->addAttribute(
                Customer::ENTITY, 'country_id', [
                    'type' => 'varchar',
                    'label' => 'Country',
                    'input' => 'select',
                    'source' => 'Magento\Customer\Model\ResourceModel\Address\Attribute\Source\Country',
                    'required' => true,
                    'sort_order' => 100,
                    'system' => false,
                    'position' => 100
                ]
            );
            $sampleAttribute = $this->eavConfig->getAttribute(Customer::ENTITY, 'country_id');
            $sampleAttribute->setData(
                'used_in_forms', ['adminhtml_customer', 'checkout_register', 'customer_account_create', 'customer_account_edit', 'adminhtml_checkout']
            );
            $sampleAttribute->save();
        }
        if (version_compare($context->getVersion(), '1.0.16') < 0) {

            $setup->startSetup();

            $eavSetup = $this->eavSetupFactory->create();

            $entityTypeId = Customer::ENTITY;
            $eavSetup->removeAttribute($entityTypeId, 'country_id');

            $setup->endSetup();
        }

        if (version_compare($context->getVersion(), '1.0.20') < 0) {
            $defaultBlocks = [
                [
                    'title' => 'Popup Newsletter Title',
                    'identifier' => 'popup_newsletter_title',
                    'content' => '<p>SUBSCRIBE TO OUR NEWSLETTER</p>',
                    'is_active' => 1,
                    'stores' => [0],
                    'sort_order' => 0
                ],
                [
                    'title' => 'Popup Newsletter Description',
                    'identifier' => 'popup_newsletter_description',
                    'content' => '<p>Subscribe to our newsletter now to get special previews of new collections and promotions.</p>',
                    'is_active' => 1,
                    'stores' => [0],
                    'sort_order' => 0
                ],
            ];


            foreach ($defaultBlocks as $block) {
                $this->blockFactory->create()->setData($block)->save();
            }
        }
    }
}
