<?php

namespace FiloBlu\Newsletter\Serialize;

use Zend\Serializer\Exception\InvalidArgumentException;

/**
 * Class Serializer
 * @package FiloBlu\Newsletter\Serialize
 */
class Serializer
{
    /**
     * @param $data
     * @return string
     */
    public function serialize($data)
    {
        if (is_resource($data)) {
            throw new InvalidArgumentException('Unable to serialize value.');
        }

        return serialize($data);
    }

    /**
     * @param $string
     * @return mixed
     */
    public function unserialize($string)
    {
        if (false === $string || null === $string || '' === $string) {
            throw new InvalidArgumentException('Unable to unserialize value.');
        }

        set_error_handler(
            static function () {
                restore_error_handler();
                throw new InvalidArgumentException('Unable to unserialize value, string is corrupted.');
            },
            E_NOTICE
        );
        $result = unserialize($string, ['allowed_classes' => false]);
        restore_error_handler();
        return $result;
    }
}
