<?php

namespace FiloBlu\Newsletter\Model\ThankYou\Source;

use FiloBlu\Newsletter\Model\ThankYou;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class PageList
 * @package FiloBlu\Newsletter\Model\ThankYou\Sourcea
 */
class PageList implements OptionSourceInterface
{
    /**
     * @var ThankYou
     */
    protected $thankYouPage;

    /**
     * PageList constructor.
     * @param ThankYou $thankYouPage
     */
    public function __construct(ThankYou $thankYouPage)
    {
        $this->thankYouPage = $thankYouPage;
    }

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options[] = ['label' => 'None', 'value' => ''];
        $availableOptions = $this->thankYouPage->getThankYouPageList();

        foreach ($availableOptions as $value) {
            $options[] = [
                'label' => "{$value['title']} - {$value['url_key']}",
                'value' => $value['thankyou_id'],
            ];
        }
        return $options;
    }

}
