<?php
namespace FiloBlu\Newsletter\Model\ResourceModel\ThankYou;

use FiloBlu\Newsletter\Model\ThankYou;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

/**
 * Class Collection
 * @package FiloBlu\Newsletter\Model\ResourceModel\ThankYou
 */
class Collection extends AbstractCollection
{

    /**
     * @var string
     */
    protected $_idFieldName = 'thankyou_id';

    /**
     * Define resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ThankYou::class, \FiloBlu\Newsletter\Model\ResourceModel\ThankYou::class);
    }

    /**
     * @param array $storeIds
     * @param bool $withDefaultStore
     * @return $this
     */
    public function addStoreFilter($storeIds = [], $withDefaultStore = true)
    {
        if (!is_array($storeIds)) {
            $storeIds = [$storeIds];
        }
        if ($withDefaultStore && !in_array('0', $storeIds)) {
            array_unshift($storeIds, 0);
        }
        $where = [];
        foreach ($storeIds as $storeId) {
            $where[] = $this->_getConditionSql('store_ids', ['finset' => $storeId]);
        }

        $this->_select->where(implode(' OR ', $where));

        return $this;
    }
}