<?php

namespace FiloBlu\Newsletter\Model\ResourceModel;

use FiloBlu\MultiDomain\Helper\Data;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Math\Random;
use Magento\Framework\Model\ResourceModel\Db\Context;
use Magento\Framework\Stdlib\DateTime\DateTime;
use Magento\Store\Model\StoreManagerInterface;

class Subscriber extends \Magento\Newsletter\Model\ResourceModel\Subscriber
{
    protected $_multiDomainHelper;
    protected $_storeManager;

    /**
     * Subscriber constructor.
     * @param Context $context
     * @param DateTime $date
     * @param Random $mathRandom
     * @param Data $multiDomainHelper
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        DateTime $date,
        Random $mathRandom,
        Data $multiDomainHelper,
        StoreManagerInterface $storeManager
    )
    {
        $this->_multiDomainHelper = $multiDomainHelper;
        $this->_storeManager = $storeManager;
        parent::__construct($context, $date, $mathRandom);
    }

    /**
     * Load subscriber from DB by email
     *
     * @param $subscriberEmail
     * @param $groupName
     * @return array
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function loadByEmail($subscriberEmail, $groupName = null)
    {
        if (!$groupName) {
            $currentGroup = $this->_multiDomainHelper->getCurrentGroup();
        } else {
            $currentGroup = $groupName;
        }

        if ($currentGroup) {
            $select = $this->connection->select()->from($this->getMainTable())->where('subscriber_email=:subscriber_email');

            $results = $this->connection->fetchAssoc($select, ['subscriber_email' => $subscriberEmail]);

            $result = false;

            foreach ($results as $r) {
                $subscriberStoreId = $r['store_id'];
                $subscriberWebsiteCode = $this->_storeManager->getStore($subscriberStoreId)->getWebsite()->getCode();
                $subscriberGroup = $this->_multiDomainHelper->getCurrentGroup($subscriberWebsiteCode);

                if ($currentGroup == $subscriberGroup) {
                    $result = $r;
                    break;
                }
            }

            if (!$result) {
                return [];
            }

            return $result;
        }

        return parent::loadByEmail($subscriberEmail);
    }

    /**
     * Load subscriber by customer
     *
     * @param CustomerInterface $customer
     * @return array
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function loadByCustomerData(CustomerInterface $customer)
    {
        $currentGroup = $this->_multiDomainHelper->getCurrentGroup();

        if ($currentGroup) {
            $select = $this->connection->select()->from($this->getMainTable())->where('customer_id=:customer_id');

            $result = $this->connection->fetchRow($select, ['customer_id' => $customer->getId()]);

            if ($result) {
                return $result;
            }

            $select = $this->connection->select()->from($this->getMainTable())->where('subscriber_email=:subscriber_email');

            $results = $this->connection->fetchAssoc($select, ['subscriber_email' => $customer->getEmail()]);

            $result = false;

            foreach ($results as $r) {
                $subscriberStoreId = $r['store_id'];
                $subscriberWebsiteCode = $this->_storeManager->getStore($subscriberStoreId)->getWebsite()->getCode();
                $subscriberGroup = $this->_multiDomainHelper->getCurrentGroup($subscriberWebsiteCode);

                if ($currentGroup == $subscriberGroup) {
                    $result = $r;
                    break;
                }
            }

            if (!$result) {
                return [];
            }

            return $result;
        }

        return parent::loadByCustomerData($customer);
    }
}
