<?php

namespace FiloBlu\Newsletter\Model\PreConfirm\Source;

use FiloBlu\Newsletter\Model\PreConfirm;
use Magento\Framework\Data\OptionSourceInterface;

class IsEnabled implements OptionSourceInterface
{
    /**
     * @var PreConfirm
     */
    protected $preConfirmPage;

    /**
     * IsEnabled constructor.
     * @param PreConfirm $preConfirmPage
     */
    public function __construct(PreConfirm $preConfirmPage)
    {
        $this->preConfirmPage = $preConfirmPage;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options[] = ['label' => '', 'value' => ''];
        $availableOptions = $this->preConfirmPage->getAvailableStatuses();

        foreach ($availableOptions as $key => $value) {
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        }
        return $options;
    }
}