<?php

namespace FiloBlu\Newsletter\Model;

use FiloBlu\Newsletter\Model\ResourceModel\PreConfirm\CollectionFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class PreConfirm
 * @package FiloBlu\Newsletter\Model
 */
class PreConfirm extends AbstractModel
{
    /**
     * @var CollectionFactory
     */
    protected $preConfirmPageCollectionFactory;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * PreConfirm constructor.
     * @param CollectionFactory $preConfirmPageCollectionFactory
     * @param StoreManagerInterface $_storeManager
     * @param Context $context
     * @param Registry $registry
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        CollectionFactory $preConfirmPageCollectionFactory,
        StoreManagerInterface $_storeManager,
        Context $context,
        Registry $registry,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->preConfirmPageCollectionFactory = $preConfirmPageCollectionFactory;
        $this->_storeManager = $_storeManager;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    public function getAvailableStatuses()
    {
        return [
            0 => 'Disabled',
            1 => 'Enabled'
        ];
    }

    public function beforeSave()
    {
        if (is_array($this->getData('store_ids'))) {
            $this->setData('store_ids', implode(',', $this->getData('store_ids')));
        }
        return parent::beforeSave();
    }

    public function getAllUrlPreConfirmPage()
    {
        $collection = $this->getAllPreConfirmPage();
        $collection->addFieldToSelect(['url_key', 'require_cookie']);

        return $collection;
    }

    public function getAllPreConfirmPage()
    {
        $collection = $this->preConfirmPageCollectionFactory->create();
        $collection->addFieldToFilter('enabled', ['eq' => 1]);
        $collection->addStoreFilter($this->_storeManager->getStore()->getId());

        return $collection;
    }

    public function getUrlPreConfirmPageById($id)
    {
        $collection = $this->getAllPreConfirmPage();
        $collection->addFieldToFilter('preconfirm_id', ['eq' => $id]);
        $collection->addFieldToSelect(['url_key']);

        return $collection->getFirstItem();
    }

    public function getPreConfirmPageById($id)
    {
        $collection = $this->getAllPreConfirmPage();
        $collection->addFieldToFilter('preconfirm_id', ['eq' => $id]);

        return $collection->getFirstItem();
    }

    public function getPreConfirmPageList()
    {
        $collection = $this->preConfirmPageCollectionFactory->create();
        $collection->addFieldToSelect(['title', 'url_key']);

        return $collection;
    }

    public function getPreConfirmPageListArray()
    {
        $collection = $this->preConfirmPageCollectionFactory->create();
        $collection->addFieldToSelect(['title', 'url_key']);

        $array = [ 0 => 'None'];

        foreach ($collection->getData() as $value) {
            $array[$value['preconfirm_id']] = "{$value['title']} - {$value['url_key']}";
        }

        return $array;
    }

    /**
     * Initialize resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\PreConfirm::class);
    }
}
