<?php

namespace FiloBlu\Newsletter\Model\Plugin;

use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Model\SubscriberInfoFactory;
use Magento\Directory\Model\RegionFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\Response\Http;
use Magento\Framework\ObjectManagerInterface;
use Magento\Store\Model\StoreManagerInterface;

class SubscriptionManager
{
    /**
     * @var ObjectManagerInterface
     */
    protected $objectManager;
    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;
    /**
     * @var Data
     */
    protected $helper;
    /**
     * @var SubscriberInfoFactory
     */
    protected $subscriberInfoFactory;
    /**
     * @var Http
     */
    protected $response;
    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var RegionFactory
     */
    protected $regionFactory;
    /**
     * @var RequestInterface
     */
    private $requestInterface;

    /**
     * @param ObjectManagerInterface $objectManager
     * @param \Magento\Framework\App\Request\Http $request
     * @param Data $helper
     * @param SubscriberInfoFactory $subscriberInfoFactory
     * @param Http $response
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     * @param RegionFactory $regionFactory
     * @param RequestInterface $requestInterface
     */
    public function __construct(
        ObjectManagerInterface              $objectManager,
        \Magento\Framework\App\Request\Http $request,
        Data                                $helper,
        SubscriberInfoFactory               $subscriberInfoFactory,
        Http                                $response,
        ScopeConfigInterface                $scopeConfig,
        StoreManagerInterface               $storeManager,
        RegionFactory                       $regionFactory,
        RequestInterface                    $requestInterface
    )
    {
        $this->objectManager = $objectManager;
        $this->request = $request;
        $this->helper = $helper;
        $this->subscriberInfoFactory = $subscriberInfoFactory;
        $this->response = $response;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->regionFactory = $regionFactory;
        $this->requestInterface = $requestInterface;
    }

    public function afterSubscribeCustomer($subject, $subscriber, int $customerId, int $storeId)
    {
        if ($this->helper->getConfig('popup/enabled') && !$this->helper->getPopupCookie()) {
            $this->helper->setPopupCookie();
        }

        if ($this->helper->getConfig('general/enabled')) {

            /** @var \Magento\Newsletter\Model\Subscriber $subscriber */
            $model = $this->subscriberInfoFactory->create();
            if ($model->load($subscriber->getSubscriberId(), 'subscriber_id')->getId()) {
                return $subscriber;
            }

            $fieldsMapping = unserialize($this->helper->getConfig('general/fields_mapping'));

            if ($fieldsMapping && count($fieldsMapping)) {
                $post = $this->request->getPost();

                if(count($post) == 0 && count($this->requestInterface->getParams())){
                    $post = $this->requestInterface->getParams();
                }

                $store = $this->storeManager->getStore($subscriber->getStoreId());
                $language = $this->helper->getStoreLanguage($subscriber->getStoreId());
                $webSiteName = $store->getWebsite()->getName();

                if (empty($post['language'])) {
                    $post['language'] = $language;
                }
                if (empty($post['website_name'])) {
                    $post['website_name'] = $webSiteName;
                }
                if (empty($post['source'])) {
                    $post['source'] = 'REGISTRATION';
                }
                if (empty($post['country_id'])) {
                    $post['country_id'] = $this->helper->getDefaultCountryByWebsite($store->getWebsite()->getId());
                }

                $model->setSubscriberId($subscriber->getSubscriberId());

                foreach ($fieldsMapping as $field) {

                    if (isset($post[$field['postname']])) {
                        if (is_array($post[$field['postname']])) {
                            $valStr = '';
                            foreach ($post[$field['postname']] as $val) {
                                if (is_string($val)) {
                                    if ($valStr) {
                                        $valStr .= ' | ' . $val;
                                    } else {
                                        $valStr = $val;
                                    }
                                }
                            }

                            if ($valStr) {
                                $model->setData($field['dbcolumnname'], $valStr);
                            }
                        } else {
                            $model->setData($field['dbcolumnname'], $post[$field['postname']]);
                        }
                    }
                }

                $model->save();
            }
        }
        return $subscriber;
    }
}
