<?php

namespace FiloBlu\Newsletter\Model;

use FiloBlu\Newsletter\Model\ResourceModel\LandingPage\CollectionFactory;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\DataObject;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Option\ArrayInterface;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class LandingPage
 * @package FiloBlu\Newsletter\Model
 */
class LandingPage extends AbstractModel implements ArrayInterface
{
    protected $landingPageCollectionFactory;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * LandingPage constructor.
     * @param CollectionFactory $landingPageCollectionFactory
     * @param StoreManagerInterface $_storeManager
     * @param Context $context
     * @param Registry $registry
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        CollectionFactory $landingPageCollectionFactory,
        StoreManagerInterface $_storeManager,
        Context $context,
        Registry $registry,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        $this->landingPageCollectionFactory = $landingPageCollectionFactory;
        $this->_storeManager = $_storeManager;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    public function getAvailableStatuses()
    {
        return [
            0 => 'Disabled',
            1 => 'Enabled'
        ];
    }

    public function getAvailableFormType()
    {
        return [
            0 => 'NEWSLETTER',
            1 => 'REGISTER',
            2 => 'NEWSLETTER EDIT'
        ];
    }

    public function beforeSave()
    {
        if (is_array($this->getData('store_ids'))) {
            $this->setData('store_ids', implode(',', $this->getData('store_ids')));
        }

        if ($this->getData('form_type') !== '1') {
            $this->setData('assign_customer_group', 0);
        }

        if ((int)$this->getData('assign_customer_group') === 0) {
            $this->setData('customer_group', null);
        }

        return parent::beforeSave();
    }

    public function getAllUrlLandingPage()
    {
        $collection = $this->getAllLandingPage();
        $collection->addFieldToSelect(['url_key']);

        return $collection;
    }

    public function getAllLandingPage()
    {
        $collection = $this->landingPageCollectionFactory->create();
        $collection->addFieldToFilter('enabled', ['eq' => 1]);
        $collection->addStoreFilter($this->_storeManager->getStore()->getId());

        return $collection;
    }

    /**
     * @param $id
     * @return LandingPage|DataObject
     */
    public function getLandingPageById($id)
    {
        $collection = $this->getAllLandingPage();
        $collection->addFieldToFilter('landing_id', ['eq' => $id]);

        return $collection->getFirstItem();
    }

    public function toOptionArray()
    {
        $id = 'customercare';
        $editFormType = '2';

        $collection = $this->getAllLandingPage();
        $collection->addFieldToSelect(['title', 'code', 'form_type']);

        $options = [];

        $options[0] = 'None';
        foreach ($collection->getData() as $value) {
            if ($value['form_type'] == $editFormType && $value['code'] == $id) {
                $options[$value['landing_id']] = "ID: {$value['landing_id']} - {$value['title']}";
            }
        }
        return $options;
    }

    /**
     * TODO: remove?
     * @return mixed
     */
    public function getEditLink()
    {
        return $this->getConfig('newsletter_edit_landing');
    }

    /**
     * Initialize resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\LandingPage::class);
    }
}
