<?php

namespace FiloBlu\Newsletter\Helper;

/**
 * Class Import
 * @package FiloBlu\Newsletter\Helper
 */
class Import extends \FiloBlu\Newsletter\Helper\Data {

    /**
     * @param $data
     * @throws \Exception
     */
    public function importDbData($data) {
        if ($data) {
            foreach ($data as $subscriberData) {
                
                // Magento default newsletter table
                $subscriber = $this->subscriberFactory->create()->loadByEmail($subscriberData['email'],$subscriberData['group_name']);
                $subscriber->setSubscriberEmail($subscriberData['email']);

                $customerId = null;
                $customerStoreId = null;
                $storeId = $this->storeManager->getStores(false, true)[$subscriberData['store_code']]->getId();
                
                try {
                    $customer = $this->customerInterface->get($subscriberData['email'],$this->storeManager->getStore($storeId)->getWebsite()->getId());
                    $customerId = $customer->getId();
                    $customerStoreId = $customer->getStoreId();
                } catch (\Exception $ex) {
                    // No customer found
                }
               
                $subscriber->setCustomerId($customerId);
                
                if ($customerStoreId) {
                    $subscriber->setStoreId($customerStoreId);
                } else {
                    $storeId = $this->storeManager->getStores(false, true)[$subscriberData['store_code']]->getId();
                    $subscriber->setStoreId($storeId);
                }

                $subscriber->setStatus($subscriberData['status']);
                $subscriber->setSubscriberConfirmCode('IMPORT');


                $subscriberId = $subscriber->save()->getId();

                // Subscriber info table
                $subscriberInfo = $this->subscriberInfoFactory->create()->load($subscriberId);
                $subscriberInfo->setSubscriberId($subscriberId);
                $subscriberInfo->addData($subscriberData);
                
                $subscriberInfo->save();
            }
        }
    }

}
