<?php

namespace FiloBlu\Newsletter\Helper;

use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;

/**
 * Class Data
 * @package FiloBlu\Newsletter\Helper
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \FiloBlu\Newsletter\Cookie\Popup
     */
    protected $cookiePopup;
    /**
     * @var \Magento\Framework\Locale\Resolver
     */
    protected $localeResolver;
    /**
     * @var \FiloBlu\Newsletter\Cookie\ThankYou
     */
    protected $cookieThankYou;
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var \FiloBlu\Newsletter\Cookie\PreConfirm
     */
    protected $cookiePreConfirm;
    /**
     * @var \Magento\Newsletter\Model\SubscriberFactory
     */
    protected $subscriberFactory;
    /**
     * @var \FiloBlu\Newsletter\Model\SubscriberInfoFactory
     */
    protected $subscriberInfoFactory;
    /**
     * @var \Magento\Customer\Api\CustomerRepositoryInterface
     */
    protected $customerInterface;

    /**
     * Data constructor.
     * @param Context $context
     * @param \FiloBlu\Newsletter\Cookie\Popup $cookiePopup
     * @param \FiloBlu\Newsletter\Cookie\ThankYou $cookieThankYou
     * @param \Magento\Framework\Locale\Resolver $localeResolver
     */
    public function __construct(Context $context,
            \FiloBlu\Newsletter\Cookie\Popup $cookiePopup,
            \FiloBlu\Newsletter\Cookie\ThankYou $cookieThankYou,
            \Magento\Framework\Locale\Resolver $localeResolver,
            \Magento\Store\Model\StoreManagerInterface $storeManager,
            \FiloBlu\Newsletter\Cookie\PreConfirm $cookiePreConfirm,
            \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory,
            \FiloBlu\Newsletter\Model\SubscriberInfoFactory $subscriberInfoFactory,
            \Magento\Customer\Api\CustomerRepositoryInterface $customerInterface
    )
    {
        parent::__construct($context);
        $this->cookiePopup = $cookiePopup;
        $this->localeResolver = $localeResolver;
        $this->cookieThankYou = $cookieThankYou;
        $this->storeManager = $storeManager;
        $this->cookiePreConfirm = $cookiePreConfirm;
        $this->subscriberFactory = $subscriberFactory;
        $this->subscriberInfoFactory = $subscriberInfoFactory;
        $this->customerInterface = $customerInterface;
    }

    /**
     * @param $configPath
     * @return mixed
     */
    public function getStoreConfig($configPath)
    {
        return $this->scopeConfig->getValue($configPath, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    public function setPopupCookie()
    {
        $this->cookiePopup->set('subscribed', $this->getConfig('popup/cookie_lifetime'));
    }

    /**
     * @param $configPath
     * @param string $section
     * @return mixed
     */
    public function getConfig($configPath, $section = 'filoblu_newsletter_section')
    {
        return $this->scopeConfig->getValue("{$section}/{$configPath}", \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    public function getPopupCookie()
    {
        return $this->cookiePopup->get();
    }

    public function deletePopupCookie()
    {
        $this->cookiePopup->delete();
    }

    public function getPopupCookieName()
    {
        return \FiloBlu\Newsletter\Cookie\Popup::COOKIE_NAME;
    }

    public function getCurrentLocale()
    {
        return $this->localeResolver->getLocale();
    }

    public function getCurrentWebsiteName()
    {
        return $this->storeManager->getWebsite()->getName();
    }

    /**
     * @param $id
     */
    public function setThankYouCookie($id)
    {
        $this->cookieThankYou->set($id, 'can_view');
    }

    public function getThankYouCookie($id)
    {
        return $this->cookieThankYou->get($id);
    }

    public function deleteThankYouCookie($id)
    {
        $this->cookieThankYou->delete($id);
    }

    public function setPreConfirmCookie($id)
    {

        $this->cookiePreConfirm->set($id, 'can_view');
    }

    public function getPreConfirmCookie($id)
    {
        return $this->cookiePreConfirm->get($id);
    }

    public function deletePreConfirmCookie($id)
    {
        $this->cookiePreConfirm->delete($id);
    }

    /**
     * @param $storeId
     * @return mixed
     */
    public function getStoreLanguage($storeId)
    {
        return $this->scopeConfig->getValue('general/locale/code', ScopeInterface::SCOPE_STORE, $storeId);
    }

    /**
     * @param $websiteId
     * @return mixed
     */
    public function getDefaultCountryByWebsite($websiteId)
    {
        return $this->scopeConfig->getValue('general/country/default', ScopeInterface::SCOPE_WEBSITE, $websiteId);
    }
}
