<?php

/**
 *
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Newsletter\Controller\Subscriber;

use Exception;
use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Model\SubscriberInfoFactory;
use FiloBlu\Newsletter\Model\ThankYou;
use Magento\Backend\App\Area\FrontNameResolver;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Newsletter\Model\SubscriberFactory;
use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;

class EditLandingAction extends Action
{

    /**
     * Sender email config path
     */
    const XML_PATH_EMAIL_SENDER = 'filoblu_newsletter_section/newsletter_edit_email/sender_email_identity';

    /**
     * Email template config path
     */
    const XML_PATH_EMAIL_TEMPLATE = 'filoblu_newsletter_section/newsletter_edit_email/email_template';

    protected $jsonResultFactory;
    public $_helper;
    protected $_modelThankYou;
    protected $_subscriberInfoFactory;
    protected $_subscriberFactory;
    protected $_storeManager;

    /**
     * @var TransportBuilder
     */
    protected $_transportBuilder;

    /**
     * @var StateInterface
     */
    protected $inlineTranslation;

    /**
     * EditLandingAction constructor.
     * @param Context $context
     * @param JsonFactory $resultJsonFactory
     * @param Data $helper
     * @param ThankYou $modelThankYou
     * @param SubscriberInfoFactory $subscriberInfoFactory
     * @param SubscriberFactory $subscriberFactory
     * @param StoreManagerInterface $storeManager
     * @param TransportBuilder $transportBuilder
     * @param StateInterface $inlineTranslation
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        Data $helper,
        ThankYou $modelThankYou,
        SubscriberInfoFactory $subscriberInfoFactory,
        SubscriberFactory $subscriberFactory,
        StoreManagerInterface $storeManager,
        TransportBuilder $transportBuilder,
        StateInterface $inlineTranslation
    ) {
        $this->resultJsonFactory = $resultJsonFactory;
        $this->_helper = $helper;
        $this->_modelThankYou = $modelThankYou;
        $this->_subscriberInfoFactory = $subscriberInfoFactory;
        $this->_subscriberFactory = $subscriberFactory;
        $this->_storeManager = $storeManager;
        $this->_transportBuilder = $transportBuilder;
        $this->inlineTranslation = $inlineTranslation;

        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface|null
     */
    public function execute()
    {
        if ($this->_helper->getConfig("general/enabled") && $this->getRequest()->isPost() && $subscriberId = $this->getRequest()->getPost('subscriber_id')) {
            $resultJson = $this->resultJsonFactory->create();

            try {
                $subscriber = $this->_subscriberFactory->create()->load($subscriberId);

                if (!$subscriber->getId()) {
                    throw new Exception("Subscriber not found");
                }

                $model = $this->_subscriberInfoFactory->create()->load($subscriberId);

                // Add subscriber info data to subscriber model
                foreach ($subscriber->getData() as $key => $value) {
                    $model->setData($key, $value);
                }

                $fieldsMappingGetCompare = unserialize($this->_helper->getConfig('general/fields_get_compare_newsletter_edit'));

                if ($fieldsMappingGetCompare && count($fieldsMappingGetCompare)) {
                    foreach ($fieldsMappingGetCompare as $field) {
                        if ($this->getRequest()->getParam($field["getname"])) {
                            if ($model->getData($field["dbcolumnname"]) != $this->getRequest()->getParam($field["getname"])) {
                                throw new Exception("Hash not correct");
                            }
                        } else {
                            throw new Exception("Hash not found");
                        }
                    }
                }

                $fieldsMapping = unserialize($this->_helper->getConfig('general/fields_mapping'));

                if ($fieldsMapping && count($fieldsMapping)) {
                    $post = $this->getRequest()->getPost();

                    foreach ($fieldsMapping as $field) {
                        if (isset($post[$field["postname"]])) {
                            if (is_array($post[$field["postname"]])) {
                                $valStr = "";
                                foreach ($post[$field["postname"]] as $val) {
                                    if (is_string($val)) {
                                        if ($valStr) {
                                            $valStr .= ' | ' . $val;
                                        } else {
                                            $valStr = $val;
                                        }
                                    }
                                }

                                if ($valStr) {
                                    $model->setData($field["dbcolumnname"], $valStr);
                                }
                            } else {
                                $model->setData($field["dbcolumnname"], $post[$field["postname"]]);
                            }
                        }
                    }

                    $model->save();
                }

                // Send email
                if ($this->_helper->getConfig('newsletter_edit_email/enabled')) {
                    $this->inlineTranslation->suspend();

                    $postObject = new DataObject();

                    $this->_transportBuilder
                            ->setTemplateIdentifier($this->_helper->getConfig('newsletter_edit_email/email_template'))
                            ->setTemplateOptions(
                                    [
                                        'area' => FrontNameResolver::AREA_CODE,
                                        'store' => Store::DEFAULT_STORE_ID,
                                    ]
                            )
                            ->setTemplateVars(['data' => $postObject])
                            ->setFrom($this->_helper->getConfig('newsletter_edit_email/sender_email_identity'))
                            ->addTo($model->getSubscriberEmail(), $model->getFirstname() . " " . $model->getLastname());

                    $transport = $this->_transportBuilder->getTransport();

                    $transport->sendMessage();

                    $this->inlineTranslation->resume();
                }

                if ($this->getRequest()->getPost('thankyou_id') && $this->getRequest()->getPost('thankyou_id') != 0) {
                    $this->_helper->setThankYouCookie($this->getRequest()->getPost('thankyou_id'));
                    $resultJson->setData(['success' => true, 'error' => false, 'redirect' => $this->_storeManager->getStore()->getBaseUrl() . $this->_modelThankYou->getUrlThankYouPageById($this->getRequest()->getPost('thankyou_id'))->getData()["url_key"]]);
                } else {
                    $resultJson->setData(['success' => true, 'error' => false, 'message' => __("Thank you for updated data."), 'redirect' => $this->_storeManager->getStore()->getBaseUrl()]);
                }

                //  Send mail
            } catch (LocalizedException $e) {
                $resultJson->setData(['success' => false, 'error' => true, 'message' => __('There was a problem with updated data: %1', $e->getMessage())]);
            } catch (Exception $e) {
                $resultJson->setData(['success' => false, 'error' => true, 'message' => __($e->getMessage())]);
            }

            return $resultJson;
        }

        return null;
    }
}
