<?php

namespace FiloBlu\Newsletter\Controller\Plugin\Subscriber;

use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Model\ThankYou;
use Magento\Newsletter\Model\Subscriber;
use Magento\Newsletter\Model\SubscriberFactory;
use Magento\Store\Model\StoreManagerInterface;

class Confirm {

    protected $_storeManager;
    protected $_helper;
    protected $_modelThankYou;

    /**
     * Subscriber factory
     *
     * @var SubscriberFactory
     */
    protected $_subscriberFactory;

    /**
     * Confirm constructor.
     * @param Data $helper
     * @param StoreManagerInterface $storeManager
     * @param ThankYou $modelThankYou
     * @param SubscriberFactory $subscriberFactory
     */
    public function __construct(Data $helper,
                                StoreManagerInterface $storeManager,
                                ThankYou $modelThankYou,
                                SubscriberFactory $subscriberFactory
    ) {
      
        $this->_helper = $helper;
        $this->_modelThankYou = $modelThankYou;
        $this->_storeManager = $storeManager;
        $this->_subscriberFactory = $subscriberFactory;
    }

    public function afterExecute(\Magento\Newsletter\Controller\Subscriber\Confirm $subject, $result) {
  
        if ($this->_helper->getConfig("general/enabled") && $subject->getRequest()->getParam('thankyou_id') && $subject->getRequest()->getParam('thankyou_id') != 0) {

            $id = (int) $subject->getRequest()->getParam('id');
            $code = (string) $subject->getRequest()->getParam('code');

            if ($id && $code) {
                /** @var Subscriber $subscriber */
                $subscriber = $this->_subscriberFactory->create()->load($id);

                if ($subscriber->getId() && $subscriber->getCode()) {
                    if ($subscriber->getStatus() == Subscriber::STATUS_SUBSCRIBED) {

                        $this->_helper->setThankYouCookie($subject->getRequest()->getParam('thankyou_id'));
                        $url = $this->_storeManager->getStore()->getBaseUrl() . $this->_modelThankYou->getUrlThankYouPageById($subject->getRequest()->getParam('thankyou_id'))->getData()["url_key"] . ($subject->getRequest()->getParams() ? "?" . http_build_query($subject->getRequest()->getParams()) : "");
                        $subject->getResponse()->setRedirect($url)->sendResponse();
                    } else {
//                    $this->messageManager->addError(__('This is an invalid subscription confirmation code.'));
                    }
                } else {
//                $this->messageManager->addError(__('This is an invalid subscription ID.'));
                }
            }
        }
    }

}
