<?php
namespace FiloBlu\Newsletter\Controller\Adminhtml\ThankYou;

use Magento\Backend\App\Action;
use Magento\TestFramework\ErrorLog\Logger;

class Save extends \Magento\Backend\App\Action
{

    protected $uploaderFactory;
    protected $imageModel;
    protected $jsHelper;

    /**
     * @param Action\Context $context
     */
    public function __construct(
        Action\Context $context,
        \Magento\MediaStorage\Model\File\UploaderFactory $uploaderFactory,
        \FiloBlu\Newsletter\Model\ThankYou\Image $imageModel,
        \Magento\Backend\Helper\Js $jsHelper
    )
    {
        $this->uploaderFactory = $uploaderFactory;
        $this->imageModel = $imageModel;
        $this->jsHelper = $jsHelper;
        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Newsletter::landing_thankyoulistsave');
    }

    /**
     * Save action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();

        if ($data) {

            $model = $this->_objectManager->create('FiloBlu\Newsletter\Model\ThankYou');

            $id = $this->getRequest()->getParam('thankyou_id');

            if ($id) {
                $model->load($id);
            }

            $model->setData($data);

            $imageName = $this->uploadFileAndGetName('image', $this->imageModel->getBaseDir(), $data);
            $model->setImage($imageName);
            

            $this->_eventManager->dispatch(
                'newsletter_thankyoupage_prepare_save',
                [
                    'thankyoupage' => $model,
                    'request' => $this->getRequest()
                ]
            );

            try {
                $model->save();
                $this->messageManager->addSuccess(__('You saved this Thank You Page.'));
                $this->_objectManager->get('Magento\Backend\Model\Session')->setFormData(false);
                if ($this->getRequest()->getParam('back')) {
                    return $resultRedirect->setPath('*/*/edit', ['thankyou_id' => $model->getId(), '_current' => true]);
                }
                return $resultRedirect->setPath('*/*/');
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\RuntimeException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addException($e, __('Something went wrong while saving the thankyou page.'));
            }

            $this->_getSession()->setFormData($data);
            return $resultRedirect->setPath('*/*/edit', ['thankyou_id' => $this->getRequest()->getParam('thankyou_id')]);
        }
        return $resultRedirect->setPath('*/*/');
    }

    public function uploadFileAndGetName($input, $destinationFolder, $data)
    {
        try {
            if (isset($data[$input]['delete'])) {
                return '';
            } else {
                $uploader = $this->uploaderFactory->create(['fileId' => $input]);
                $uploader->setAllowRenameFiles(true);
                $uploader->setFilesDispersion(true);
                $uploader->setAllowCreateFolders(true);
                $result = $uploader->save($destinationFolder);
                return $result['file'];
            }
        } catch (\Exception $e) {
            if ($e->getCode() != \Magento\Framework\File\Uploader::TMP_NAME_EMPTY) {
                throw new FrameworkException($e->getMessage());
            } else {
                if (isset($data[$input]['value'])) {
                    return $data[$input]['value'];
                }
            }
        }
        return '';
    }
}
