<?php
namespace FiloBlu\Newsletter\Controller\Adminhtml\PreConfirm;

use Magento\Backend\App\Action;

class Edit extends \Magento\Backend\App\Action
{
    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry = null;

    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;

    /**
     * @param Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Magento\Framework\Registry $registry
     */
    public function __construct(
        Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Registry $registry
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->_coreRegistry = $registry;
        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Newsletter::newsletter_preconfirmlistdelete');
    }

    /**
     * Init actions
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    protected function _initAction()
    {
        // load layout, set active menu and breadcrumbs
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('FiloBlu_Newsletter::landing_preconfirmlistnew')
            ->addBreadcrumb(__('Pre Confirm Page'), __('Pre Confirm Page'))
            ->addBreadcrumb(__('Manage Pre Confirm Page'), __('Manage Pre Confirm Page'));
        return $resultPage;
    }

    public function execute()
    {
        $id = $this->getRequest()->getParam('preconfirm_id');

        $model = $this->_objectManager->create('FiloBlu\Newsletter\Model\PreConfirm');

        if ($id) {
            $model->load($id);
            if (!$model->getId()) {
                $this->messageManager->addError(__('This preconfirm page no longer exists.'));
                /** \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
                $resultRedirect = $this->resultRedirectFactory->create();

                return $resultRedirect->setPath('*/*/');
            }
        }

        $data = $this->_objectManager->get('Magento\Backend\Model\Session')->getFormData(true);
        if (!empty($data)) {
            $model->setData($data);
        }

        $this->_coreRegistry->register('newsletter_preconfirmpage', $model);

        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->_initAction();
        $resultPage->addBreadcrumb(
            $id ? __('Edit Pre Confirm Page') : __('New Pre Confirm Page'),
            $id ? __('Edit Pre Confirm Page') : __('New Pre Confirm Page')
        );
        $resultPage->getConfig()->getTitle()->prepend(__('Pre Confirm Page'));
        $resultPage->getConfig()->getTitle()
            ->prepend($model->getId() ? $model->getTitle() : __('New Pre Confirm Page'));

        return $resultPage;
    }
}