<?php
namespace FiloBlu\Newsletter\Controller\Adminhtml\PreConfirm;

use Magento\Backend\App\Action;
use Magento\TestFramework\ErrorLog\Logger;

class Delete extends \Magento\Backend\App\Action
{
    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Newsletter::newsletter_preconfirmlistdelete');
    }

    /**
     * Delete action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('preconfirm_id');
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                $model = $this->_objectManager->create('FiloBlu\Newsletter\Model\PreConfirm');
                $model->load($id);
                $model->delete();
                $this->messageManager->addSuccess(__('The preconfirm page has been deleted.'));
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['preconfirm_id' => $id]);
            }
        }
        $this->messageManager->addError(__('We can\'t find a preconfirm page to delete.'));
        return $resultRedirect->setPath('*/*/');
    }
}