<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Newsletter\Block\Widget;

use FiloBlu\Newsletter\Helper\Data;
use Magento\Customer\Api\CustomerMetadataInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Helper\Address;
use Magento\Customer\Model\Session;
use Magento\Framework\View\Element\Template\Context;

/**
 * Block to render customer's gender attribute
 *
 * @SuppressWarnings(PHPMD.DepthOfInheritance)
 */
class Gender extends \Magento\Customer\Block\Widget\Gender
{
    /**
     * @var Data
     */
    protected $_helper;

    /**
     * Gender constructor.
     * @param Context $context
     * @param Address $addressHelper
     * @param CustomerMetadataInterface $customerMetadata
     * @param CustomerRepositoryInterface $customerRepository
     * @param Session $customerSession
     * @param Data $helperData
     * @param array $data
     */
    public function __construct(
        Context $context,
        Address $addressHelper,
        CustomerMetadataInterface $customerMetadata,
        CustomerRepositoryInterface $customerRepository,
        Session $customerSession,
        Data $helperData,
        array $data = []
    )
    {
        parent::__construct($context, $addressHelper, $customerMetadata, $customerRepository, $customerSession, $data);
        $this->_helper = $helperData;
    }

    public function _construct()
    {
        parent::_construct();
        $this->setTemplate('widget/gender.phtml');
    }

    /**
     * Check if gender attribute marked as required
     * @return bool
     */
    public function isRequired()
    {
        return $this->_helper->getConfig('popup/gender_required') ? true : false;
    }
}
