<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\Newsletter\Block\Widget;

use FiloBlu\Newsletter\Helper\Data;
use FiloBlu\Newsletter\Magento\Framework\View\Element\Html\Date;
use Magento\Customer\Api\CustomerMetadataInterface;
use Magento\Customer\Helper\Address;
use Magento\Framework\Data\Form\FilterFactory;
use Magento\Framework\View\Element\Template\Context;

/**
 * Class Dob
 *
 * @SuppressWarnings(PHPMD.DepthOfInheritance)
 */
class Dob extends \Magento\Customer\Block\Widget\Dob
{
    /**
     * @var Data
     */
    protected $_helper;

    /**
     * Dob constructor.
     * @param Context $context
     * @param Address $addressHelper
     * @param CustomerMetadataInterface $customerMetadata
     * @param Date $dateElementNewsletter
     * @param FilterFactory $filterFactory
     * @param Data $helperData
     * @param array $data
     */
    public function __construct(
        Context $context,
        Address $addressHelper,
        CustomerMetadataInterface $customerMetadata,
        Date $dateElementNewsletter,
        FilterFactory $filterFactory,
        Data $helperData,
        array $data = []
    )
    {
        $this->dateElement = $dateElementNewsletter;
        $this->_helper = $helperData;
        parent::__construct($context, $addressHelper, $customerMetadata, $dateElementNewsletter, $filterFactory, $data);
    }

    /**
     * @return void
     */
    public function _construct()
    {
        parent::_construct();
        $this->setTemplate('Magento_Customer::widget/dob.phtml');
    }


    /**
     * Return id
     *
     * @return string
     */
    public function getHtmlId()
    {
        return 'dob-newsletter';
    }

    /**
     * @return bool
     */
    public function isRequired()
    {
        return $this->_helper->getConfig('popup/dob_required') ? true : false;
    }


}
