<?php

namespace FiloBlu\Newsletter\Block;

use FiloBlu\Newsletter\Block\Widget\Country;
use FiloBlu\Newsletter\Helper\Data;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class Popup extends Template
{

    /**
     * Helper
     *
     * @var Data
     */
    public $_helper;
    public $_directoryBlock;

    /**
     * Popup constructor.
     * @param Context $context
     * @param Data $helper
     * @param Widget\Country $directoryBlock
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $helper,
        Country $directoryBlock,
        array $data = []
    )
    {
        $this->_helper = $helper;
        $this->_directoryBlock = $directoryBlock;
        parent::__construct($context, $data);
    }

    /**
     * @return string
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getCountries()
    {
        $country = $this->_directoryBlock->getCountryHtmlSelect(null, 'country_id', 'country_newsletter', 'Country');
        return $country;
    }

    /**
     * Retrieve form action url and set "secure" param to avoid confirm
     * message when we submit form from secure page to unsecure
     *
     * @return string
     */
    public function getFormActionUrl()
    {
        return $this->getUrl('newsletterajax/subscriber/new', ['_secure' => true]);
    }

    protected function _toHtml()
    {

        if (!$this->_helper->getConfig('popup/enabled')) {
            return '';
        }

        return parent::_toHtml();
    }

    protected function getCacheLifetime()
    {
        return 3600;
    }

    /**
     * @param $string
     * @param bool $escapeSingleQuote
     * @return string
     */
    public function escapeHtmlAttr($string, $escapeSingleQuote = true)
    {
        return $this->_escaper->escapeHtmlAttr($string, $escapeSingleQuote);
    }

}
