<?php

namespace FiloBlu\Newsletter\Block\LandingPage;

use FiloBlu\Newsletter\Helper\Data;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Cms\Model\Template\FilterProvider;

class LandingPage extends Template
{
    public $_helper;
    protected $request;

    /**
     * Store manager
     *
     * @var StoreManagerInterface
     */
    protected $_storeManager;
    protected $_coreRegistry;

    /**
     * @var FilterProvider
     */
    protected $_filterProvider;

    /**
     * LandingPage constructor.
     * @param Context $context
     * @param Data $helper
     * @param Http $request
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        FilterProvider $filterProvider,
        Context $context,
        Data $helper,
        Http $request,
        Registry $registry,
        array $data = []
    ) {
        $this->_filterProvider = $filterProvider;
        $this->_helper = $helper;
        $this->request = $request;
        $this->_storeManager = $context->getStoreManager();
        $this->_coreRegistry = $registry;

        parent::__construct($context, $data);
    }

    /**
     * @param $image
     * @return string
     * @throws NoSuchEntityException
     */
    public function getImageUrl($image)
    {
        return $this->_storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_MEDIA) . 'filoblu/newsletter/landingpage/image' . $image;
    }

    public function _prepareLayout()
    {
        if ($this->getLandingPage()['code']) {
            $this->pageConfig->addBodyClass('filoblunewsletterfrontend-index-landingpage-' . $this->getLandingPage()['code']);
        }
        return parent::_prepareLayout();
    }

    public function getLandingPage()
    {
        if (!$this->getLandingPageEntity()) {
            $this->setLandingPageEntity($this->_coreRegistry->registry('newsletter_landingpage_entity'));
        }

        return $this->getLandingPageEntity()->getData();
    }

    public function getDescription($content)
    {
        return $this->_filterProvider->getPageFilter()->filter($content);
    }

    protected function _toHtml()
    {
        if (!$this->_helper->getConfig('general/enabled')) {
            return '';
        }

        $landing = $this->getLandingPage();

        $this->setTemplate("FiloBlu_Newsletter::landingpage/landing_page_{$landing['code']}.phtml");

        if (!$this->getTemplateFile()) {
            $this->setTemplate('FiloBlu_Newsletter::landingpage/landing_page.phtml');
        }

        return parent::_toHtml();
    }
}
